@extends('layouts.admin')

@section('title', 'Başvuru Detayı')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-file-earmark-text"></i> Başvuru Detayı</h1>
        <a href="{{ route('admin.superadmin.applications') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>

    <div class="row g-4">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white border-0 py-3">
                    <h5 class="mb-0">Başvuru Bilgileri</h5>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th width="200">Şirket Adı:</th>
                            <td>{{ $application->company_name }}</td>
                        </tr>
                        <tr>
                            <th>İletişim Kişisi:</th>
                            <td>{{ $application->contact_person }}</td>
                        </tr>
                        <tr>
                            <th>E-posta:</th>
                            <td>{{ $application->email }}</td>
                        </tr>
                        <tr>
                            <th>Telefon:</th>
                            <td>{{ $application->phone }}</td>
                        </tr>
                        <tr>
                            <th>Şehir:</th>
                            <td>{{ $application->city ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Adres:</th>
                            <td>{{ $application->address ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Durum:</th>
                            <td>
                                @if($application->status === 'pending')
                                    <span class="badge bg-warning">Bekliyor</span>
                                @elseif($application->status === 'approved')
                                    <span class="badge bg-success">Onaylandı</span>
                                @else
                                    <span class="badge bg-danger">Reddedildi</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Başvuru Tarihi:</th>
                            <td>{{ $application->created_at->format('d.m.Y H:i') }}</td>
                        </tr>
                        @if($application->description)
                        <tr>
                            <th>Açıklama:</th>
                            <td>{{ $application->description }}</td>
                        </tr>
                        @endif
                        @if($application->admin_notes)
                        <tr>
                            <th>Yönetici Notları:</th>
                            <td>{{ $application->admin_notes }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            @if($application->status === 'pending')
            <div class="card border-0 shadow-sm mb-3">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-check-circle"></i> Onayla</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.superadmin.applications.approve', $application->id) }}">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">Notlar (Opsiyonel)</label>
                            <textarea name="admin_notes" class="form-control" rows="3"></textarea>
                        </div>
                        <button type="submit" class="btn btn-success w-100">
                            <i class="bi bi-check-circle"></i> Başvuruyu Onayla
                        </button>
                    </form>
                </div>
            </div>
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0"><i class="bi bi-x-circle"></i> Reddet</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.superadmin.applications.reject', $application->id) }}">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">Red Nedeni <span class="text-danger">*</span></label>
                            <textarea name="admin_notes" class="form-control" rows="3" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="bi bi-x-circle"></i> Başvuruyu Reddet
                        </button>
                    </form>
                </div>
            </div>
            @else
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <p class="text-muted">Bu başvuru zaten {{ $application->status === 'approved' ? 'onaylanmış' : 'reddedilmiş' }}.</p>
                    @if($application->reviewer)
                    <p class="small text-muted">
                        İnceleyen: {{ $application->reviewer->name }}<br>
                        Tarih: {{ $application->reviewed_at->format('d.m.Y H:i') }}
                    </p>
                    @endif
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

