@extends('layouts.admin')

@section('title', 'Firmalar')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-building"></i> Firmalar</h1>
        <a href="{{ route('admin.superadmin.companies.create') }}" class="btn btn-primary">
            <i class="bi bi-building-add"></i> Yeni Firma
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Firma Adı</th>
                            <th>E-posta</th>
                            <th>Telefon</th>
                            <th>Kullanıcı Sayısı</th>
                            <th>Randevu Sayısı</th>
                            <th>Durum</th>
                            <th>Kayıt Tarihi</th>
                            <th width="150">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($companies as $company)
                        <tr>
                            <td>{{ $company->name }}</td>
                            <td>{{ $company->email ?? '-' }}</td>
                            <td>{{ $company->phone ?? '-' }}</td>
                            <td>{{ $company->users_count }}</td>
                            <td>{{ $company->appointments_count }}</td>
                            <td>
                                @if($company->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-secondary">Pasif</span>
                                @endif
                            </td>
                            <td>{{ $company->created_at->format('d.m.Y') }}</td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.superadmin.companies.show', $company->id) }}" class="btn btn-outline-primary" title="Görüntüle">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.superadmin.companies.edit', $company->id) }}" class="btn btn-outline-secondary" title="Düzenle">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.superadmin.companies.destroy.post', $company->id) }}" method="POST" class="d-inline delete-form" data-message="Bu firmayı silmek istediğinize emin misiniz?">
                                        @csrf
                                        <button type="submit" class="btn btn-outline-danger" title="Sil">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">Firma bulunamadı</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                {{ $companies->links() }}
            </div>
        </div>
    </div>
</div>
@endsection

