@extends('layouts.admin')

@section('title', 'Firma Detayı')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-building"></i> Firma Detayı</h1>
        <div>
            <a href="{{ route('admin.superadmin.companies.edit', $company->id) }}" class="btn btn-primary">
                <i class="bi bi-pencil"></i> Düzenle
            </a>
            <a href="{{ route('admin.superadmin.companies') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Geri
            </a>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white border-0 py-3">
                    <h5 class="mb-0">Firma Bilgileri</h5>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th width="200">Firma Adı:</th>
                            <td>{{ $company->name }}</td>
                        </tr>
                        <tr>
                            <th>E-posta:</th>
                            <td>{{ $company->email ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Telefon:</th>
                            <td>{{ $company->phone ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Adres:</th>
                            <td>{{ $company->address ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Vergi No:</th>
                            <td>{{ $company->tax_number ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Durum:</th>
                            <td>
                                @if($company->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-secondary">Pasif</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Kayıt Tarihi:</th>
                            <td>{{ $company->created_at->format('d.m.Y H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white border-0 py-3">
                    <h5 class="mb-0">Kullanıcılar ({{ $company->users->count() }})</h5>
                </div>
                <div class="card-body">
                    @forelse($company->users as $user)
                    <div class="d-flex justify-content-between align-items-center mb-2 p-2 bg-light rounded">
                        <div>
                            <strong>{{ $user->name }}</strong><br>
                            <small class="text-muted">{{ $user->email }}</small>
                        </div>
                        <span class="badge bg-primary">{{ $user->pivot->role_in_company ?? 'Üye' }}</span>
                    </div>
                    @empty
                    <p class="text-muted">Kullanıcı bulunamadı</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white border-0 py-3">
                    <h5 class="mb-0">Randevular ({{ $company->appointments->count() }})</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Kod</th>
                                    <th>Müşteri</th>
                                    <th>Tarih</th>
                                    <th>Tutar</th>
                                    <th>Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($company->appointments->take(10) as $reservation)
                                <tr>
                                    <td>{{ $reservation->code }}</td>
                                    <td>{{ $reservation->customer->name ?? '-' }}</td>
                                    <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                    <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                    <td>
                                        <span class="badge bg-{{ $reservation->status === 'confirmed' ? 'success' : ($reservation->status === 'cancelled' ? 'danger' : 'warning') }}">
                                            {{ ucfirst($reservation->status) }}
                                        </span>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted">Randevu bulunamadı</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

