@extends('layouts.admin')

@section('title', 'Kupon Düzenle')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-tag"></i> Kupon Düzenle</h1>
        <a href="{{ route('admin.superadmin.coupons.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('admin.superadmin.coupons.update', $coupon->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Kupon kodu <span class="text-danger">*</span></label>
                        <input type="text" name="code" class="form-control" value="{{ old('code', $coupon->code) }}" required maxlength="64">
                        @error('code')<div class="text-danger small">{{ $message }}</div>@enderror
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Ad (isteğe bağlı)</label>
                        <input type="text" name="name" class="form-control" value="{{ old('name', $coupon->name) }}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Tip <span class="text-danger">*</span></label>
                        <select name="type" id="couponType" class="form-select" required>
                            <option value="subscription" {{ old('type', $coupon->type) === 'subscription' ? 'selected' : '' }}>Ücretsiz kullanım süresi (gün)</option>
                            <option value="sms" {{ old('type', $coupon->type) === 'sms' ? 'selected' : '' }}>SMS hakkı</option>
                            <option value="both" {{ old('type', $coupon->type) === 'both' ? 'selected' : '' }}>İkisi birden</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3" id="fieldSubscriptionDays">
                        <label class="form-label">Ücretsiz gün sayısı</label>
                        <input type="number" name="subscription_days" class="form-control" value="{{ old('subscription_days', $coupon->subscription_days) }}" min="0">
                    </div>
                    <div class="col-md-3 mb-3" id="fieldSmsCredits">
                        <label class="form-label">SMS adedi</label>
                        <input type="number" name="sms_credits" class="form-control" value="{{ old('sms_credits', $coupon->sms_credits) }}" min="0">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Maks. kullanım (boş = sınırsız)</label>
                        <input type="number" name="max_uses" class="form-control" value="{{ old('max_uses', $coupon->max_uses) }}" min="1">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Geçerlilik başlangıç</label>
                        <input type="date" name="valid_from" class="form-control" value="{{ old('valid_from', $coupon->valid_from?->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Geçerlilik bitiş</label>
                        <input type="date" name="valid_until" class="form-control" value="{{ old('valid_until', $coupon->valid_until?->format('Y-m-d')) }}">
                    </div>
                </div>
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', $coupon->is_active) ? 'checked' : '' }}>
                        <label class="form-check-label" for="is_active">Aktif</label>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check2-circle"></i> Güncelle
                </button>
            </form>
        </div>
    </div>
</div>
@endsection
