@extends('layouts.admin')

@section('title', 'Kupon Yönetimi')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-tag"></i> Kupon Yönetimi</h1>
        <a href="{{ route('admin.superadmin.coupons.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni Kupon
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Kod</th>
                            <th>Ad</th>
                            <th>Tip</th>
                            <th>Ücretsiz gün</th>
                            <th>SMS</th>
                            <th>Kullanım</th>
                            <th>Geçerlilik</th>
                            <th>Aktif</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($coupons as $coupon)
                        <tr>
                            <td><code>{{ $coupon->code }}</code></td>
                            <td>{{ $coupon->name ?? '—' }}</td>
                            <td>
                                @if($coupon->type === 'subscription')
                                    <span class="badge bg-info">Abonelik</span>
                                @elseif($coupon->type === 'sms')
                                    <span class="badge bg-warning text-dark">SMS</span>
                                @else
                                    <span class="badge bg-primary">İkisi</span>
                                @endif
                            </td>
                            <td>{{ $coupon->subscription_days ? $coupon->subscription_days . ' gün' : '—' }}</td>
                            <td>{{ $coupon->sms_credits ? $coupon->sms_credits : '—' }}</td>
                            <td>{{ $coupon->used_count }}{{ $coupon->max_uses ? ' / ' . $coupon->max_uses : '' }}</td>
                            <td>
                                @if($coupon->valid_from || $coupon->valid_until)
                                    {{ $coupon->valid_from ? $coupon->valid_from->format('d.m.Y') : '—' }} - {{ $coupon->valid_until ? $coupon->valid_until->format('d.m.Y') : '—' }}
                                @else
                                    Sınırsız
                                @endif
                            </td>
                            <td>
                                @if($coupon->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-secondary">Pasif</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.superadmin.coupons.edit', $coupon->id) }}" class="btn btn-sm btn-primary"><i class="bi bi-pencil"></i></a>
                                <form action="{{ route('admin.superadmin.coupons.destroy', $coupon->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu kuponu silmek istediğinizden emin misiniz?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted py-5">Henüz kupon eklenmemiş.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($coupons->hasPages())
                <div class="d-flex justify-content-center mt-3">{{ $coupons->links() }}</div>
            @endif
        </div>
    </div>
</div>
@endsection
