@extends('layouts.admin')

@section('title', 'Süper Admin Dashboard')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-shield-check"></i> Süper Admin Paneli</h1>
    </div>

    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-primary bg-opacity-10 rounded p-3">
                                <i class="bi bi-people text-primary fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Kullanıcı</h6>
                            <h3 class="mb-0">{{ $stats['total_users'] }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-info bg-opacity-10 rounded p-3">
                                <i class="bi bi-calendar-check text-info fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Randevu</h6>
                            <h3 class="mb-0">{{ $stats['total_appointments'] }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-warning bg-opacity-10 rounded p-3">
                                <i class="bi bi-hourglass-split text-warning fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Bekleyen Ödemeler</h6>
                            <h3 class="mb-0">{{ $stats['pending_payments'] ?? 0 }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <!-- Quick Actions -->
    <div class="row g-4 mt-4">
        @if(($stats['pending_payments'] ?? 0) > 0)
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100 border-warning border-2">
                <div class="card-body text-center">
                    <div class="bg-warning bg-opacity-10 rounded-circle p-4 d-inline-block mb-3">
                        <i class="bi bi-hourglass-split text-warning fs-2"></i>
                    </div>
                    <h5 class="mb-3 text-primary">Bekleyen Ödemeler</h5>
                    <p class="text-muted mb-3">{{ $stats['pending_payments'] }} adet havale/EFT ödemesi onay bekliyor</p>
                    <a href="{{ route('admin.superadmin.pending-payments') }}" class="btn btn-warning">
                        <i class="bi bi-arrow-right"></i> Ödemeleri İncele
                    </a>
                </div>
            </div>
        </div>
        @endif
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="bg-warning bg-opacity-10 rounded-circle p-4 d-inline-block mb-3">
                        <i class="bi bi-people text-warning fs-2"></i>
                    </div>
                    <h5 class="mb-3 text-primary">Kullanıcı Yönetimi</h5>
                    <p class="text-muted mb-3">Kullanıcıları görüntüleyin, oluşturun ve yönetin</p>
                    <a href="{{ route('admin.superadmin.users') }}" class="btn btn-warning">
                        <i class="bi bi-arrow-right"></i> Kullanıcıları Yönet
                    </a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="bg-primary bg-opacity-10 rounded-circle p-4 d-inline-block mb-3">
                        <i class="bi bi-box-seam text-primary fs-2"></i>
                    </div>
                    <h5 class="mb-3 text-primary">Paket Yönetimi</h5>
                    <p class="text-muted mb-3">Fiyat paketlerini ve özelliklerini yönetin</p>
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.superadmin.packages.index') }}" class="btn btn-primary">
                            <i class="bi bi-arrow-right"></i> Paketleri Yönet
                        </a>
                        <a href="{{ route('admin.superadmin.pricing-settings') }}" class="btn btn-outline-primary">
                            <i class="bi bi-sliders"></i> Ana Sayfa Paket Seçimi
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="bg-success bg-opacity-10 rounded-circle p-4 d-inline-block mb-3">
                        <i class="bi bi-chat-quote text-success fs-2"></i>
                    </div>
                    <h5 class="mb-3 text-primary">Müşteri Yorumları</h5>
                    <p class="text-muted mb-3">Ana sayfadaki müşteri yorumlarını yönetin</p>
                    <a href="{{ route('admin.superadmin.testimonials.index') }}" class="btn btn-success">
                        <i class="bi bi-arrow-right"></i> Yorumları Yönet
                    </a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="bg-info bg-opacity-10 rounded-circle p-4 d-inline-block mb-3">
                        <i class="bi bi-download text-info fs-2"></i>
                    </div>
                    <h5 class="mb-3 text-primary">Uygulama İndirmeleri</h5>
                    <p class="text-muted mb-3">Windows, Android ve iOS indirme linklerini yönetin</p>
                    <a href="{{ route('admin.superadmin.app-downloads') }}" class="btn btn-info">
                        <i class="bi bi-arrow-right"></i> İndirme Linklerini Yönet
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Test SMS Card -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h5 class="mb-1 text-primary"><i class="bi bi-chat-dots"></i> Test SMS Gönder</h5>
                            <p class="text-muted mb-0">SMS Gateway sistemini test etmek için test SMS gönderin</p>
                        </div>
                        <a href="{{ route('admin.superadmin.test-sms') }}" class="btn btn-primary">
                            <i class="bi bi-send"></i> Test SMS Gönder
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

