@extends('layouts.admin')

@section('title', 'Paket Düzenle')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-pencil"></i> Paket Düzenle</h1>
        <a href="{{ route('admin.superadmin.packages.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri Dön
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('admin.superadmin.packages.update', $package->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Paket Adı <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" value="{{ old('name', $package->name) }}" required>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Sıra No</label>
                        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', $package->sort_order) }}" min="0">
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Açıklama</label>
                    <textarea name="description" class="form-control" rows="3">{{ old('description', $package->description) }}</textarea>
                </div>
                
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Fiyat (₺) <span class="text-danger">*</span></label>
                        <input type="number" name="price" class="form-control" value="{{ old('price', $package->price) }}" step="0.01" min="0" required>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Fiyat Dönemi <span class="text-danger">*</span></label>
                        <select name="price_period" class="form-select" required>
                            <option value="monthly" {{ old('price_period', $package->price_period) === 'monthly' ? 'selected' : '' }}>Aylık</option>
                            <option value="yearly" {{ old('price_period', $package->price_period) === 'yearly' ? 'selected' : '' }}>Yıllık</option>
                        </select>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Süre (Ay) <span class="text-danger">*</span></label>
                        <input type="number" name="duration_months" class="form-control" value="{{ old('duration_months', $package->duration_months ?? 1) }}" min="1" required>
                        <small class="text-muted">Paket süresi (ay cinsinden)</small>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <div class="form-check mt-4">
                            <input class="form-check-input" type="checkbox" name="is_popular" id="is_popular" value="1" {{ old('is_popular', $package->is_popular) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_popular">
                                Popüler Paket
                            </label>
                        </div>
                        
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', $package->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Aktif
                            </label>
                        </div>
                    </div>
                </div>
                
                <hr class="my-4">
                
                <h5 class="mb-3 text-primary"><i class="bi bi-list-check"></i> Paket Özellikleri</h5>
                <div id="featuresContainer">
                    @if(old('features'))
                        @foreach(old('features') as $index => $feature)
                        <div class="feature-item mb-3 p-3 border rounded">
                            <div class="d-flex align-items-center gap-2">
                                <input type="text" name="features[]" class="form-control" value="{{ $feature }}" placeholder="Özellik adı" required>
                                <button type="button" class="btn btn-sm btn-danger" onclick="removeFeature(this)">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                        @endforeach
                    @else
                        @foreach($package->features ?? [] as $index => $feature)
                        <div class="feature-item mb-3 p-3 border rounded">
                            <div class="d-flex align-items-center gap-2">
                                <input type="text" name="features[]" class="form-control" value="{{ $feature }}" placeholder="Özellik adı" required>
                                <button type="button" class="btn btn-sm btn-danger" onclick="removeFeature(this)">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                        @endforeach
                        @if(empty($package->features))
                        <div class="feature-item mb-3 p-3 border rounded">
                            <div class="d-flex align-items-center gap-2">
                                <input type="text" name="features[]" class="form-control" placeholder="Özellik adı" required>
                                <button type="button" class="btn btn-sm btn-danger" onclick="removeFeature(this)">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                        @endif
                    @endif
                </div>
                
                <button type="button" class="btn btn-sm btn-outline-primary mb-3" onclick="addFeature()">
                    <i class="bi bi-plus-circle"></i> Özellik Ekle
                </button>
                
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Güncelle
                    </button>
                    <a href="{{ route('admin.superadmin.packages.index') }}" class="btn btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function addFeature() {
    const container = document.getElementById('featuresContainer');
    const newFeature = document.createElement('div');
    newFeature.className = 'feature-item mb-3 p-3 border rounded';
    newFeature.innerHTML = `
        <div class="d-flex align-items-center gap-2">
            <input type="text" name="features[]" class="form-control" placeholder="Özellik adı" required>
            <button type="button" class="btn btn-sm btn-danger" onclick="removeFeature(this)">
                <i class="bi bi-trash"></i>
            </button>
        </div>
    `;
    container.appendChild(newFeature);
}

function removeFeature(button) {
    button.closest('.feature-item').remove();
}
</script>
@endsection
