@extends('layouts.admin')

@section('title', 'Paket Yönetimi')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-box-seam"></i> Paket Yönetimi</h1>
        <a href="{{ route('admin.superadmin.packages.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni Paket Ekle
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Ad</th>
                            <th>Açıklama</th>
                            <th>Fiyat</th>
                            <th>Dönem</th>
                            <th>Süre (Ay)</th>
                            <th>Özellikler</th>
                            <th>Popüler</th>
                            <th>Aktif</th>
                            <th>Sıra</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($packages as $package)
                        <tr>
                            <td><strong>{{ $package->name }}</strong></td>
                            <td>{{ Str::limit($package->description, 50) }}</td>
                            <td>{{ $package->formatted_price }}</td>
                            <td>{{ $package->price_period === 'monthly' ? 'Aylık' : 'Yıllık' }}</td>
                            <td>{{ $package->duration_months ?? 1 }} ay</td>
                            <td>{{ count($package->features ?? []) }} özellik</td>
                            <td>
                                @if($package->is_popular)
                                    <span class="badge bg-success">Evet</span>
                                @else
                                    <span class="badge bg-secondary">Hayır</span>
                                @endif
                            </td>
                            <td>
                                @if($package->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-danger">Pasif</span>
                                @endif
                            </td>
                            <td>{{ $package->sort_order }}</td>
                            <td>
                                <a href="{{ route('admin.superadmin.packages.edit', $package->id) }}" class="btn btn-sm btn-primary">
                                    <i class="bi bi-pencil"></i> Düzenle
                                </a>
                                <form action="{{ route('admin.superadmin.packages.destroy', $package->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu paketi silmek istediğinizden emin misiniz?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i> Sil
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10" class="text-center text-muted py-5">
                                <i class="bi bi-inbox" style="font-size: 3rem; display: block; margin-bottom: 1rem;"></i>
                                Henüz paket eklenmemiş.
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
