@extends('layouts.admin')

@section('title', 'Bekleyen Ödemeler')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary">
            <i class="bi bi-hourglass-split me-2"></i>Bekleyen Ödemeler
        </h1>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if($pendingPayments->count() > 0)
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Tarih</th>
                            <th>Kullanıcı</th>
                            <th>Açıklama</th>
                            <th>Tutar</th>
                            <th>Referans No</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pendingPayments as $payment)
                        @php
                            $merchantOid = $payment->payment_reference;
                            $isPackage = strpos($merchantOid, 'PKG_') === 0;
                            $packageInfo = null;
                            if ($isPackage) {
                                $parts = explode('_', $merchantOid);
                                if (count($parts) >= 3) {
                                    $packageId = $parts[1];
                                    $packageInfo = \App\Models\Package::find($packageId);
                                }
                            }
                        @endphp
                        <tr>
                            <td>
                                <div>{{ $payment->created_at->format('d.m.Y') }}</div>
                                <small class="text-muted">{{ $payment->created_at->format('H:i') }}</small>
                            </td>
                            <td>
                                <div class="fw-bold">{{ $payment->user->name ?? 'Bilinmiyor' }}</div>
                                <small class="text-muted">{{ $payment->user->email ?? '' }}</small>
                                @if($payment->user && $payment->user->phone)
                                <div><small class="text-muted"><i class="bi bi-telephone me-1"></i>{{ $payment->user->phone }}</small></div>
                                @endif
                            </td>
                            <td>
                                <div>{{ $payment->description }}</div>
                                @if($packageInfo)
                                <small class="text-info"><i class="bi bi-box-seam me-1"></i>{{ $packageInfo->name }} ({{ $packageInfo->duration_months ?? 1 }} ay)</small>
                                @endif
                            </td>
                            <td>
                                <span class="fw-bold text-success">{{ number_format($payment->amount, 2, ',', '.') }} ₺</span>
                            </td>
                            <td>
                                <code class="small">{{ $payment->payment_reference }}</code>
                            </td>
                            <td>
                                <div class="d-flex gap-2">
                                    <form action="{{ route('admin.superadmin.pending-payments.approve', $payment->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Bu ödemeyi onaylamak istediğinize emin misiniz? @if($packageInfo){{ $packageInfo->name }} paketi aktif edilecektir.@endif');">
                                            <i class="bi bi-check-circle me-1"></i>Onayla
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.superadmin.pending-payments.reject', $payment->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Bu ödemeyi reddetmek istediğinize emin misiniz?');">
                                            <i class="bi bi-x-circle me-1"></i>Reddet
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4">
                {{ $pendingPayments->links() }}
            </div>
        </div>
    </div>
    @else
    <div class="card border-0 shadow-sm">
        <div class="card-body text-center py-5">
            <i class="bi bi-check-circle text-success" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">Bekleyen ödeme bulunmuyor</h4>
            <p class="text-muted">Tüm ödemeler işlenmiş durumda.</p>
        </div>
    </div>
    @endif
</div>
@endsection
