@extends('layouts.admin')

@section('title', 'Paket Seçimi - Ana Sayfa')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-sliders"></i> Ana Sayfa Paket Seçimi</h1>
        <a href="{{ route('admin.superadmin.packages.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Paket Yönetimine Dön
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-header">
            <h5 class="mb-0"><i class="bi bi-info-circle"></i> Bilgi</h5>
        </div>
        <div class="card-body">
            <p class="mb-0">Ana sayfadaki fiyatlandırma bölümünde gösterilecek 3 paketi seçin. Paketler soldan sağa sırayla görüntülenecektir.</p>
        </div>
    </div>

    <form action="{{ route('admin.superadmin.pricing-settings.update') }}" method="POST" class="mt-4">
        @csrf
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-1-circle"></i> 1. Paket (Sol)</h5>
                    </div>
                    <div class="card-body">
                        <label class="form-label fw-bold">Paket Seçin</label>
                        <select name="pricing_package_1" class="form-select">
                            <option value="">-- Paket Seçin --</option>
                            @foreach($packages as $package)
                                <option value="{{ $package->id }}" {{ $selectedPackage1 == $package->id ? 'selected' : '' }}>
                                    {{ $package->name }} - ₺{{ number_format($package->price, 0) }}/{{ $package->price_period === 'monthly' ? 'ay' : 'yıl' }}
                                </option>
                            @endforeach
                        </select>
                        @if($selectedPackage1)
                            @php
                                $pkg = $packages->firstWhere('id', $selectedPackage1);
                            @endphp
                            @if($pkg)
                                <div class="mt-3 p-3 bg-light rounded">
                                    <small class="text-muted d-block">Seçili Paket:</small>
                                    <strong>{{ $pkg->name }}</strong>
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="bi bi-2-circle"></i> 2. Paket (Orta)</h5>
                    </div>
                    <div class="card-body">
                        <label class="form-label fw-bold">Paket Seçin</label>
                        <select name="pricing_package_2" class="form-select">
                            <option value="">-- Paket Seçin --</option>
                            @foreach($packages as $package)
                                <option value="{{ $package->id }}" {{ $selectedPackage2 == $package->id ? 'selected' : '' }}>
                                    {{ $package->name }} - ₺{{ number_format($package->price, 0) }}/{{ $package->price_period === 'monthly' ? 'ay' : 'yıl' }}
                                </option>
                            @endforeach
                        </select>
                        @if($selectedPackage2)
                            @php
                                $pkg = $packages->firstWhere('id', $selectedPackage2);
                            @endphp
                            @if($pkg)
                                <div class="mt-3 p-3 bg-light rounded">
                                    <small class="text-muted d-block">Seçili Paket:</small>
                                    <strong>{{ $pkg->name }}</strong>
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0"><i class="bi bi-3-circle"></i> 3. Paket (Sağ)</h5>
                    </div>
                    <div class="card-body">
                        <label class="form-label fw-bold">Paket Seçin</label>
                        <select name="pricing_package_3" class="form-select">
                            <option value="">-- Paket Seçin --</option>
                            @foreach($packages as $package)
                                <option value="{{ $package->id }}" {{ $selectedPackage3 == $package->id ? 'selected' : '' }}>
                                    {{ $package->name }} - ₺{{ number_format($package->price, 0) }}/{{ $package->price_period === 'monthly' ? 'ay' : 'yıl' }}
                                </option>
                            @endforeach
                        </select>
                        @if($selectedPackage3)
                            @php
                                $pkg = $packages->firstWhere('id', $selectedPackage3);
                            @endphp
                            @if($pkg)
                                <div class="mt-3 p-3 bg-light rounded">
                                    <small class="text-muted d-block">Seçili Paket:</small>
                                    <strong>{{ $pkg->name }}</strong>
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <div class="mt-4">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-save"></i> Kaydet
            </button>
            <a href="{{ route('admin.superadmin.packages.index') }}" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> İptal
            </a>
        </div>
    </form>
</div>
@endsection
