@extends('layouts.admin')

@section('title', 'Salon Yıldız Yönetimi')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0 text-primary">
            <i class="bi bi-stars"></i> Salon Yıldız Yönetimi
        </h2>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ $errors->first() }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm mb-3">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.superadmin.salon-ratings.index') }}" class="row g-2">
                <div class="col-md-8">
                    <input type="text" name="q" value="{{ $search ?? '' }}" class="form-control" placeholder="Salon adına göre ara...">
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search me-1"></i>Ara
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Salon</th>
                            <th>Müşteri</th>
                            <th>Yıldız</th>
                            <th>Yorum</th>
                            <th>Durum</th>
                            <th>Tarih</th>
                            <th>İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($ratings as $rating)
                            <tr>
                                <td>
                                    <strong>{{ $rating->salon->salon_name ?? $rating->salon->name ?? '-' }}</strong>
                                </td>
                                <td>{{ $rating->customer_name ?: ($rating->customer_phone ?: '-') }}</td>
                                <td style="min-width: 140px;">
                                    <form method="POST" action="{{ route('admin.superadmin.salon-ratings.update', $rating->id) }}" class="d-flex flex-column gap-2">
                                        @csrf
                                        @method('PUT')
                                        <select name="rating" class="form-select form-select-sm" required>
                                            @for($star = 1; $star <= 5; $star++)
                                                <option value="{{ $star }}" {{ (int)$rating->rating === $star ? 'selected' : '' }}>
                                                    {{ $star }} Yıldız
                                                </option>
                                            @endfor
                                        </select>
                                </td>
                                <td style="min-width: 240px;">
                                        <textarea name="comment" class="form-control form-control-sm" rows="2" maxlength="1000" placeholder="Yorum">{{ $rating->comment }}</textarea>
                                </td>
                                <td style="min-width: 130px;">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" name="is_used" value="1" id="is_used_{{ $rating->id }}" {{ $rating->is_used ? 'checked' : '' }}>
                                            <label class="form-check-label small" for="is_used_{{ $rating->id }}">
                                                {{ $rating->is_used ? 'Yayında' : 'Gizli' }}
                                            </label>
                                        </div>
                                </td>
                                <td>
                                    {{ optional($rating->created_at)->format('d.m.Y H:i') }}
                                </td>
                                <td>
                                        <button type="submit" class="btn btn-sm btn-success">
                                            <i class="bi bi-check2-circle"></i> Kaydet
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">
                                    <i class="bi bi-inbox"></i> Değerlendirme kaydı bulunamadı.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $ratings->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
