@extends('layouts.admin')

@section('title', 'Test SMS Gönder')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-chat-dots"></i> Test SMS Gönder</h1>
        <a href="{{ route('admin.superadmin.dashboard') }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Geri Dön
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle"></i> {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-lg-8">
            <!-- SMS Gönderme Formu -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-send"></i> SMS Gönder</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.superadmin.test-sms.send') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="phone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('phone') is-invalid @enderror" 
                                   id="phone" 
                                   name="phone" 
                                   value="{{ old('phone') }}" 
                                   placeholder="05551234567 veya +905551234567"
                                   required>
                            <div class="form-text">Türk telefon numarası formatında girin (05551234567 veya +905551234567)</div>
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="message" class="form-label">Mesaj <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('message') is-invalid @enderror" 
                                      id="message" 
                                      name="message" 
                                      rows="4" 
                                      placeholder="Test mesajınızı buraya yazın..."
                                      required>{{ old('message') }}</textarea>
                            <div class="form-text">
                                <span id="char-count">0</span> / 1000 karakter
                            </div>
                            @error('message')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="provider" class="form-label">SMS Sağlayıcı</label>
                            <select class="form-select @error('provider') is-invalid @enderror" 
                                    id="provider" 
                                    name="provider">
                                <option value="1sms" selected>1SMS</option>
                            </select>
                            <div class="form-text">Sadece 1SMS aktif</div>
                            @error('provider')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-send"></i> SMS Gönder
                        </button>
                    </form>
                </div>
            </div>

            <!-- OTP Gönderme Formu -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-shield-lock"></i> Test OTP Gönder</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.superadmin.test-sms.otp') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="otp_phone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('otp_phone') is-invalid @enderror" 
                                   id="otp_phone" 
                                   name="phone" 
                                   value="{{ old('otp_phone') }}" 
                                   placeholder="05551234567 veya +905551234567"
                                   required>
                            <div class="form-text">OTP kodu gönderilecek telefon numarası</div>
                            @error('otp_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="otp_provider" class="form-label">SMS Sağlayıcı</label>
                            <select class="form-select @error('otp_provider') is-invalid @enderror" 
                                    id="otp_provider" 
                                    name="provider">
                                <option value="1sms" selected>1SMS</option>
                            </select>
                            <div class="form-text">Sadece 1SMS aktif</div>
                            @error('otp_provider')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <button type="submit" class="btn btn-success">
                            <i class="bi bi-shield-lock"></i> OTP Gönder
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Bilgi Kartı -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="bi bi-info-circle"></i> Bilgi</h5>
                </div>
                <div class="card-body">
                    <h6 class="fw-bold mb-3">SMS Gönderme</h6>
                    <ul class="list-unstyled mb-4">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            SMS'ler varsayılan olarak queue üzerinden gönderilir
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Telefon numaraları otomatik olarak normalize edilir
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Tüm gönderimler loglanır
                        </li>
                    </ul>

                    <h6 class="fw-bold mb-3">OTP Gönderme</h6>
                    <ul class="list-unstyled mb-4">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            6 haneli OTP kodu otomatik oluşturulur
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Rate limiting aktif (dakikada 3, 10 dakikada 8)
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            OTP 5 dakika geçerlidir
                        </li>
                    </ul>

                    <h6 class="fw-bold mb-3">Provider Ayarları</h6>
                    <p class="text-muted small mb-0">
                        Provider ayarları <code>config/sms.php</code> ve <code>.env</code> dosyalarından yönetilir.
                    </p>
                </div>
            </div>

            <!-- Son Gönderimler -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0"><i class="bi bi-clock-history"></i> Son Gönderimler</h5>
                </div>
                <div class="card-body">
                    <p class="text-muted small mb-0">
                        SMS loglarını görüntülemek için log sayfasını ziyaret edin.
                    </p>
                    <a href="{{ route('admin.superadmin.test-sms') }}" class="btn btn-sm btn-outline-secondary mt-2">
                        <i class="bi bi-arrow-clockwise"></i> Yenile
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Karakter sayacı
    document.getElementById('message').addEventListener('input', function() {
        const charCount = this.value.length;
        document.getElementById('char-count').textContent = charCount;
        
        if (charCount > 1000) {
            document.getElementById('char-count').classList.add('text-danger');
        } else {
            document.getElementById('char-count').classList.remove('text-danger');
        }
    });

    // Telefon numarası formatı kontrolü
    document.getElementById('phone').addEventListener('blur', function() {
        let phone = this.value.replace(/\D/g, '');
        if (phone.startsWith('0')) {
            phone = '+90' + phone.substring(1);
        } else if (!phone.startsWith('90')) {
            phone = '+90' + phone;
        } else {
            phone = '+' + phone;
        }
        if (phone.length === 13 && phone.startsWith('+905')) {
            this.value = phone;
        }
    });

    document.getElementById('otp_phone').addEventListener('blur', function() {
        let phone = this.value.replace(/\D/g, '');
        if (phone.startsWith('0')) {
            phone = '+90' + phone.substring(1);
        } else if (!phone.startsWith('90')) {
            phone = '+90' + phone;
        } else {
            phone = '+' + phone;
        }
        if (phone.length === 13 && phone.startsWith('+905')) {
            this.value = phone;
        }
    });
</script>
@endpush
@endsection

