@extends('layouts.admin')

@section('title', 'Test WhatsApp Gönder')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-whatsapp"></i> Test WhatsApp Gönder</h1>
        <a href="{{ route('admin.superadmin.dashboard') }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Geri Dön
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle"></i> {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('reg_id'))
        <div class="alert alert-info alert-dismissible fade show" role="alert">
            <i class="bi bi-info-circle"></i> 
            <strong>Reg ID:</strong> {{ session('reg_id') }}
            @if(session('code'))
                <br><strong>Kod:</strong> {{ session('code') }} (WhatsApp'tan gelen bildirime tıklayıp 30 saniye içinde girin)
            @endif
            @if(session('qr'))
                <br><strong>QR Kod:</strong> WhatsApp uygulamasından 30 saniye içinde okutun
            @endif
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-lg-8">
            <!-- WhatsApp Giriş - Telefon -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-phone"></i> Telefon ile Giriş</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.superadmin.test-whatsapp.login.phone') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="login_phone" class="form-label">WhatsApp Telefon Numarası <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('phone') is-invalid @enderror" 
                                   id="login_phone" 
                                   name="phone" 
                                   value="{{ old('phone') }}" 
                                   placeholder="05551234567 veya +905551234567"
                                   required>
                            <div class="form-text">WhatsApp'a kayıtlı telefon numaranızı girin</div>
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="login_provider" class="form-label">Provider</label>
                            <select class="form-select" id="login_provider" name="provider">
                                <option value="vatansms" selected>VatanSMS</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-success">
                            <i class="bi bi-phone"></i> Telefon ile Giriş Yap
                        </button>
                    </form>
                </div>
            </div>

            <!-- WhatsApp Giriş - QR Kod -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-qr-code"></i> QR Kod ile Giriş</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.superadmin.test-whatsapp.login.qr') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="qr_provider" class="form-label">Provider</label>
                            <select class="form-select" id="qr_provider" name="provider">
                                <option value="vatansms" selected>VatanSMS</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-qr-code"></i> QR Kod Oluştur
                        </button>
                    </form>

                    @if(session('qr'))
                        <div class="mt-3">
                            <p class="text-muted small">QR Kodu WhatsApp uygulamasından okutun:</p>
                            <div class="text-center">
                                <canvas id="qrcode" class="border rounded p-2 bg-white"></canvas>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Giriş Kontrolü -->
            @if(session('reg_id'))
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0"><i class="bi bi-check-circle"></i> Giriş Kontrolü</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.superadmin.test-whatsapp.login.check') }}" method="POST" id="checkLoginForm">
                        @csrf
                        <input type="hidden" name="reg_id" value="{{ session('reg_id') }}">
                        <input type="hidden" name="provider" value="vatansms">
                        
                        <p class="text-muted">Giriş işleminin tamamlanıp tamamlanmadığını kontrol edin.</p>
                        
                        <button type="submit" class="btn btn-warning">
                            <i class="bi bi-check-circle"></i> Giriş Durumunu Kontrol Et
                        </button>
                    </form>
                </div>
            </div>
            @endif

            <!-- WhatsApp Mesaj Gönderme -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="bi bi-send"></i> WhatsApp Mesaj Gönder</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.superadmin.test-whatsapp.send') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="reg_id" class="form-label">Reg ID <span class="text-danger">*</span></label>
                            <select class="form-select @error('reg_id') is-invalid @enderror" 
                                    id="reg_id" 
                                    name="reg_id" 
                                    required>
                                <option value="">Reg ID Seçin...</option>
                                @if(isset($sessions) && $sessions->count() > 0)
                                    @if(isset($activeRegId) && $activeRegId)
                                        @foreach($sessions as $session)
                                            <option value="{{ $session->reg_id }}" 
                                                    {{ ($activeRegId == $session->reg_id) ? 'selected' : '' }}>
                                                {{ $session->reg_id }}
                                                @if($session->user_name)
                                                    - {{ $session->user_name }}
                                                @endif
                                                @if($session->is_connected)
                                                    (Bağlı)
                                                @else
                                                    (Bağlı Değil)
                                                @endif
                                            </option>
                                        @endforeach
                                    @else
                                        @foreach($sessions as $session)
                                        <option value="{{ $session->reg_id }}" 
                                                {{ (session('reg_id') == $session->reg_id) ? 'selected' : '' }}>
                                            {{ $session->reg_id }}
                                            @if($session->user_name)
                                                - {{ $session->user_name }}
                                            @endif
                                            @if($session->is_connected)
                                                (Bağlı)
                                            @else
                                                (Bağlı Değil)
                                            @endif
                                        </option>
                                    @endforeach
                                    @endif
                                @endif
                            </select>
                            <div class="form-text">Aktif session'lardan Reg ID seçin veya yeni giriş yapın</div>
                            @error('reg_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="whatsapp_phone" class="form-label">Alıcı Telefon Numarası <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('phone') is-invalid @enderror" 
                                   id="whatsapp_phone" 
                                   name="phone" 
                                   value="{{ old('phone') }}" 
                                   placeholder="05551234567 veya +905551234567"
                                   required>
                            <div class="form-text">Mesajın gönderileceği WhatsApp numarası</div>
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="whatsapp_message" class="form-label">Mesaj <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('message') is-invalid @enderror" 
                                      id="whatsapp_message" 
                                      name="message" 
                                      rows="4" 
                                      placeholder="Test WhatsApp mesajınızı buraya yazın..."
                                      required>{{ old('message') }}</textarea>
                            <div class="form-text">
                                <span id="whatsapp-char-count">0</span> / 1000 karakter
                            </div>
                            @error('message')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="whatsapp_provider" class="form-label">Provider</label>
                            <select class="form-select" id="whatsapp_provider" name="provider">
                                <option value="vatansms" selected>VatanSMS</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-info text-white">
                            <i class="bi bi-send"></i> WhatsApp Mesajı Gönder
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Aktif Session'lar -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-person-check"></i> Aktif Session'lar</h5>
                </div>
                <div class="card-body">
                    @if(isset($sessions) && $sessions->count() > 0)
                        <div class="list-group">
                            @foreach($sessions as $session)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <h6 class="mb-1">
                                                @if($session->user_name)
                                                    {{ $session->user_name }}
                                                @else
                                                    Session #{{ $session->id }}
                                                @endif
                                            </h6>
                                            <p class="mb-1 small text-muted">
                                                <strong>Reg ID:</strong> {{ $session->reg_id }}<br>
                                                @if($session->device_number)
                                                    <strong>Numara:</strong> {{ $session->device_number }}<br>
                                                @endif
                                                @if($session->platform)
                                                    <strong>Platform:</strong> {{ $session->platform }}<br>
                                                @endif
                                                <strong>Durum:</strong> 
                                                @if($session->is_connected)
                                                    <span class="badge bg-success">Bağlı</span>
                                                @else
                                                    <span class="badge bg-warning">Bağlı Değil</span>
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                    <small class="text-muted">
                                        {{ $session->created_at->diffForHumans() }}
                                    </small>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted small mb-0">Henüz aktif session yok. Giriş yaparak başlayın.</p>
                    @endif
                </div>
            </div>

            <!-- Bilgi Kartı -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="bi bi-info-circle"></i> Bilgi</h5>
                </div>
                <div class="card-body">
                    <h6 class="fw-bold mb-3">WhatsApp Giriş</h6>
                    <ul class="list-unstyled mb-4">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Telefon ile giriş: WhatsApp'tan kod gelir, 30 saniye içinde girin
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            QR kod ile giriş: QR kodu WhatsApp'tan okutun, 30 saniye içinde
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Giriş kontrolü: İlk giriş için "Giriş Kontrolü" butonunu kullanın
                        </li>
                    </ul>

                    <h6 class="fw-bold mb-3">Mesaj Gönderme</h6>
                    <ul class="list-unstyled mb-4">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Önce giriş yapmalısınız (Reg ID gerekli)
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Tüm mesajlar loglanır
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i> 
                            Callback desteği aktif
                        </li>
                    </ul>

                    <h6 class="fw-bold mb-3">Provider Ayarları</h6>
                    <p class="text-muted small mb-0">
                        Provider ayarları <code>config/whatsapp.php</code> ve <code>.env</code> dosyalarından yönetilir.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>
<script>
    // Karakter sayacı
    document.getElementById('whatsapp_message').addEventListener('input', function() {
        const charCount = this.value.length;
        document.getElementById('whatsapp-char-count').textContent = charCount;
        
        if (charCount > 1000) {
            document.getElementById('whatsapp-char-count').classList.add('text-danger');
        } else {
            document.getElementById('whatsapp-char-count').classList.remove('text-danger');
        }
    });

    // Telefon numarası formatı kontrolü
    const phoneInputs = ['login_phone', 'whatsapp_phone'];
    phoneInputs.forEach(inputId => {
        const input = document.getElementById(inputId);
        if (input) {
            input.addEventListener('blur', function() {
                let phone = this.value.replace(/\D/g, '');
                if (phone.startsWith('0')) {
                    phone = '+90' + phone.substring(1);
                } else if (!phone.startsWith('90')) {
                    phone = '+90' + phone;
                } else {
                    phone = '+' + phone;
                }
                if (phone.length === 13 && phone.startsWith('+905')) {
                    this.value = phone;
                }
            });
        }
    });

    // QR Kod oluşturma
    @if(session('qr'))
        document.addEventListener('DOMContentLoaded', function() {
            const qrContainer = document.getElementById("qrcode");
            if (qrContainer && typeof QRCode !== 'undefined') {
                QRCode.toCanvas(qrContainer, "{{ session('qr') }}", {
                    width: 256,
                    margin: 2,
                    color: {
                        dark: '#000000',
                        light: '#ffffff'
                    }
                }, function (error) {
                    if (error) {
                        console.error('QR Code generation error:', error);
                        qrContainer.innerHTML = '<p class="text-danger">QR kod oluşturulamadı</p>';
                    }
                });
            }
        });
    @endif

    // Giriş kontrolü otomatik yenileme
    @if(session('reg_id'))
        let checkInterval;
        const checkLoginForm = document.getElementById('checkLoginForm');
        
        if (checkLoginForm) {
            // İlk kontrolü 5 saniye sonra yap
            setTimeout(function() {
                checkLoginForm.submit();
            }, 5000);

            // Her 10 saniyede bir kontrol et
            checkInterval = setInterval(function() {
                checkLoginForm.submit();
            }, 10000);

            // Form submit edildiğinde interval'i durdur
            checkLoginForm.addEventListener('submit', function() {
                clearInterval(checkInterval);
            });
        }
    @endif
</script>
@endpush
@endsection

