@extends('layouts.admin')

@section('title', 'Yeni Müşteri Yorumu Ekle')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-plus-circle"></i> Yeni Müşteri Yorumu Ekle</h1>
        <a href="{{ route('admin.superadmin.testimonials.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri Dön
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('admin.superadmin.testimonials.store') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Müşteri Adı <span class="text-danger">*</span></label>
                        <input type="text" name="customer_name" class="form-control" value="{{ old('customer_name') }}" required placeholder="Örn: Ahmet Yılmaz">
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Unvan/Pozisyon</label>
                        <input type="text" name="customer_title" class="form-control" value="{{ old('customer_title') }}" placeholder="Örn: İşletme Sahibi, Genel Müdür">
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Şirket Adı</label>
                        <input type="text" name="company_name" class="form-control" value="{{ old('company_name') }}" placeholder="Örn: ABC Düğün Salonu">
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Puan <span class="text-danger">*</span></label>
                        <select name="rating" class="form-select" required>
                            <option value="5" {{ old('rating', 5) == 5 ? 'selected' : '' }}>5 Yıldız</option>
                            <option value="4" {{ old('rating') == 4 ? 'selected' : '' }}>4 Yıldız</option>
                            <option value="3" {{ old('rating') == 3 ? 'selected' : '' }}>3 Yıldız</option>
                            <option value="2" {{ old('rating') == 2 ? 'selected' : '' }}>2 Yıldız</option>
                            <option value="1" {{ old('rating') == 1 ? 'selected' : '' }}>1 Yıldız</option>
                        </select>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Sıra No</label>
                        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', 0) }}" min="0">
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Yorum <span class="text-danger">*</span></label>
                    <textarea name="comment" class="form-control" rows="5" required placeholder="Müşteri yorumu...">{{ old('comment') }}</textarea>
                    <small class="text-muted">Gerçekçi ve samimi bir yorum yazın</small>
                </div>
                
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label class="form-check-label" for="is_active">
                            Aktif (Ana sayfada gösterilsin)
                        </label>
                    </div>
                </div>
                
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Kaydet
                    </button>
                    <a href="{{ route('admin.superadmin.testimonials.index') }}" class="btn btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
