@extends('layouts.admin')

@section('title', 'Müşteri Yorumları Yönetimi')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-chat-quote"></i> Müşteri Yorumları Yönetimi</h1>
        <a href="{{ route('admin.superadmin.testimonials.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni Yorum Ekle
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Müşteri Adı</th>
                            <th>Unvan/Şirket</th>
                            <th>Yorum</th>
                            <th>Puan</th>
                            <th>Aktif</th>
                            <th>Sıra</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($testimonials as $testimonial)
                        <tr>
                            <td><strong>{{ $testimonial->customer_name }}</strong></td>
                            <td>
                                @if($testimonial->customer_title)
                                    {{ $testimonial->customer_title }}<br>
                                @endif
                                @if($testimonial->company_name)
                                    <small class="text-muted">{{ $testimonial->company_name }}</small>
                                @endif
                            </td>
                            <td>{{ \Illuminate\Support\Str::limit($testimonial->comment, 80) }}</td>
                            <td>
                                @for($i = 1; $i <= 5; $i++)
                                    <i class="bi bi-star{{ $i <= $testimonial->rating ? '-fill' : '' }}" style="color: {{ $i <= $testimonial->rating ? '#fbbf24' : '#e2e8f0' }};"></i>
                                @endfor
                            </td>
                            <td>
                                @if($testimonial->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-danger">Pasif</span>
                                @endif
                            </td>
                            <td>{{ $testimonial->sort_order }}</td>
                            <td>
                                <a href="{{ route('admin.superadmin.testimonials.edit', $testimonial->id) }}" class="btn btn-sm btn-primary">
                                    <i class="bi bi-pencil"></i> Düzenle
                                </a>
                                <form action="{{ route('admin.superadmin.testimonials.destroy', $testimonial->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu yorumu silmek istediğinizden emin misiniz?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i> Sil
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted py-5">
                                <i class="bi bi-inbox" style="font-size: 3rem; display: block; margin-bottom: 1rem;"></i>
                                Henüz müşteri yorumu eklenmemiş.
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
