@extends('layouts.admin')

@section('title', 'Kullanıcı Düzenle')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-person-gear"></i> Kullanıcı Düzenle</h1>
        <a href="{{ route('admin.superadmin.users') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri Dön
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <form method="POST" action="{{ route('admin.superadmin.users.update', $user->id) }}">
                @csrf
                @method('PUT')

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="name" class="form-label">Ad Soyad <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $user->name) }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">E-posta <span class="text-danger">*</span></label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $user->email) }}" required>
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="phone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="tel" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', $user->phone) }}" required placeholder="05XX XXX XX XX">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="password" class="form-label">Şifre <small class="text-muted">(Değiştirmek istemiyorsanız boş bırakın)</small></label>
                        <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password">
                        @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="role" class="form-label">Rol</label>
                        <select class="form-select @error('role') is-invalid @enderror" id="role" name="role">
                            <option value="">Mevcut Rolü Koru</option>
                            <option value="super_admin" {{ old('role', $user->role) === 'super_admin' ? 'selected' : '' }}>Süper Admin</option>
                            <option value="admin" {{ old('role', $user->role) === 'admin' ? 'selected' : '' }}>Randevucu</option>
                            <option value="güzellik_salonu" {{ old('role', $user->role) === 'güzellik_salonu' ? 'selected' : '' }}>Güzellik Salonu</option>
                        </select>
                        <div class="form-text">Mevcut rol: <strong>{{ $user->role === 'super_admin' ? 'Süper Admin' : ($user->role === 'admin' ? 'Randevucu' : ($user->role === 'güzellik_salonu' ? 'Güzellik Salonu' : $user->role)) }}</strong></div>
                        @error('role')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="company_id" class="form-label">Firma</label>
                        <select class="form-select @error('company_id') is-invalid @enderror" id="company_id" name="company_id">
                            <option value="">Firma Seçiniz</option>
                            @foreach($companies as $company)
                                <option value="{{ $company->id }}" {{ old('company_id', $user->company_id) == $company->id ? 'selected' : '' }}>
                                    {{ $company->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('company_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="package_id" class="form-label">Paket <small class="text-muted">(Lisans süresini uzatır)</small></label>
                        <select class="form-select @error('package_id') is-invalid @enderror" id="package_id" name="package_id">
                            <option value="">Paket Seçiniz</option>
                            @foreach($packages as $package)
                                <option value="{{ $package->id }}" {{ old('package_id') == $package->id ? 'selected' : '' }}>
                                    {{ $package->name }} 
                                    @if($package->duration_months)
                                        ({{ $package->duration_months }} ay)
                                    @endif
                                    @if($package->price > 0)
                                        - {{ $package->formatted_price }}
                                    @else
                                        - Ücretsiz
                                    @endif
                                </option>
                            @endforeach
                        </select>
                        <div class="form-text">
                            Seçilen paketin süresi kullanıcının mevcut lisans süresine eklenecektir.
                            @if($user->license_expires_at)
                                <br>Mevcut lisans bitiş: <strong>{{ \Carbon\Carbon::parse($user->license_expires_at)->format('d.m.Y H:i') }}</strong>
                            @else
                                <br>Mevcut lisans: <strong class="text-danger">Yok</strong>
                            @endif
                        </div>
                        @error('package_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $user->is_active) ? 'checked' : '' }}>
                        <label class="form-check-label" for="is_active">
                            Aktif
                        </label>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.superadmin.users') }}" class="btn btn-secondary">İptal</a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Güncelle
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

