@extends('layouts.admin')

@section('title', 'Kullanıcı Yönetimi - SMS ve Lisans')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0 text-primary">
            <i class="bi bi-people"></i> Kullanıcı Yönetimi
        </h2>
        <a href="{{ route('admin.superadmin.users.create') }}" class="btn btn-primary">
            <i class="bi bi-person-plus"></i> Yeni Kullanıcı Ekle
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>Ad Soyad</th>
                            <th>E-posta</th>
                            <th>Telefon</th>
                            <th>Rol</th>
                            <th>SMS Bakiyesi</th>
                            <th>Lisans Süresi</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($users as $user)
                            <tr>
                                <td><strong>{{ $user->name }}</strong></td>
                                <td>{{ $user->email }}</td>
                                <td>{{ $user->phone ?? '-' }}</td>
                                <td>
                                    @if($user->role === 'super_admin')
                                        <span class="badge bg-danger">
                                            <i class="bi bi-shield-check"></i> Süper Admin
                                        </span>
                                    @elseif($user->role === 'admin')
                                        <span class="badge bg-primary">
                                            <i class="bi bi-person"></i> Randevucu
                                        </span>
                                    @else
                                        <span class="badge bg-secondary">
                                            {{ ucfirst($user->role) }}
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <form method="POST" action="{{ route('admin.superadmin.update-sms-balance', $user->id) }}" class="d-inline-flex align-items-center gap-2" onsubmit="return confirm('SMS bakiyesini güncellemek istediğinize emin misiniz?');">
                                        @csrf
                                        <input type="number" name="sms_balance" value="{{ $user->sms_balance ?? 0 }}" class="form-control form-control-sm" style="width: 100px;" min="0" required>
                                        <button type="submit" class="btn btn-sm btn-success">
                                            <i class="bi bi-check"></i> Güncelle
                                        </button>
                                    </form>
                                </td>
                                <td>
                                    <form method="POST" action="{{ route('admin.superadmin.update-license', $user->id) }}" class="d-inline-flex flex-wrap align-items-center gap-2" onsubmit="return confirm('Lisans süresini güncellemek istediğinize emin misiniz?');">
                                        @csrf
                                        @php
                                            $licenseDays = 0;
                                            $isUnlimited = !$user->license_expires_at;
                                            if ($user->license_expires_at) {
                                                $now = \Carbon\Carbon::now();
                                                $expires = \Carbon\Carbon::parse($user->license_expires_at);
                                                $licenseDays = max(0, (int)$now->diffInDays($expires, false));
                                            }
                                        @endphp
                                        <div class="d-inline-flex align-items-center gap-2">
                                            <input type="number" name="license_days" id="license_days_{{ $user->id }}" value="{{ $licenseDays }}" class="form-control form-control-sm" style="width: 90px;" min="0" placeholder="Gün" {{ $isUnlimited ? 'disabled' : '' }}>
                                            <span class="text-muted small">gün</span>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input license-unlimited-check" type="checkbox" name="license_unlimited" value="1" id="license_unlimited_{{ $user->id }}" data-user-id="{{ $user->id }}" {{ $isUnlimited ? 'checked' : '' }}>
                                            <label class="form-check-label small" for="license_unlimited_{{ $user->id }}">Süresiz</label>
                                        </div>
                                        <button type="submit" class="btn btn-sm btn-primary">
                                            <i class="bi bi-check"></i> Güncelle
                                        </button>
                                    </form>
                                    <script>
                                    document.getElementById('license_unlimited_{{ $user->id }}')?.addEventListener('change', function() {
                                        var daysInput = document.getElementById('license_days_{{ $user->id }}');
                                        daysInput.disabled = this.checked;
                                        if (this.checked) daysInput.value = '';
                                    });
                                    </script>
                                    @if($user->license_expires_at)
                                        <div class="mt-2">
                                            <div class="small">
                                                <strong>Bitiş:</strong> 
                                                <span class="badge {{ \Carbon\Carbon::parse($user->license_expires_at)->isPast() ? 'bg-danger' : 'bg-success' }}">
                                                    {{ \Carbon\Carbon::parse($user->license_expires_at)->format('d.m.Y H:i') }}
                                                </span>
                                            </div>
                                            @if($user->package)
                                                <div class="small text-primary mt-1">
                                                    <i class="bi bi-box-seam"></i> <strong>Paket:</strong> {{ $user->package->name }}
                                                    @if($user->package->duration_months)
                                                        <span class="text-muted">({{ $user->package->duration_months }} ay)</span>
                                                    @endif
                                                </div>
                                            @endif
                                            @php
                                                $now = \Carbon\Carbon::now()->startOfDay();
                                                $expires = \Carbon\Carbon::parse($user->license_expires_at)->startOfDay();
                                                $remainingDays = (int)$now->diffInDays($expires, false);
                                            @endphp
                                            @if($remainingDays > 0)
                                                <div class="small text-success mt-1">
                                                    <i class="bi bi-clock"></i> Kalan: <strong>{{ $remainingDays }} gün</strong>
                                                </div>
                                            @elseif($remainingDays == 0)
                                                <div class="small text-warning mt-1">
                                                    <i class="bi bi-exclamation-triangle"></i> Bugün doluyor!
                                                </div>
                                            @else
                                                <div class="small text-danger mt-1">
                                                    <i class="bi bi-exclamation-triangle"></i> Süresi dolmuş! ({{ abs($remainingDays) }} gün önce)
                                                </div>
                                            @endif
                                        </div>
                                    @else
                                        <div class="small text-success mt-1">
                                            <i class="bi bi-infinity"></i> Sınırsız
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    @php
                                        $hasValidLicense = $user->hasValidLicense();
                                    @endphp
                                    @if($hasValidLicense)
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle"></i> Aktif
                                        </span>
                                    @else
                                        <span class="badge bg-danger">
                                            <i class="bi bi-x-circle"></i> Süresi Dolmuş
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.superadmin.users.show', $user->id) }}" class="btn btn-sm btn-info" title="Görüntüle">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.superadmin.users.edit', $user->id) }}" class="btn btn-sm btn-primary" title="Düzenle">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        @if($user->role !== 'super_admin')
                                            <form method="POST" action="{{ route('admin.superadmin.users.destroy.post', $user->id) }}" class="d-inline" onsubmit="return confirm('{{ addslashes($user->name) }} adlı kullanıcıyı silmek istediğinize emin misiniz? Bu işlem geri alınamaz.');">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-danger" title="Sil">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">
                                    <i class="bi bi-inbox"></i> Henüz kullanıcı bulunmamaktadır.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $users->links() }}
            </div>
        </div>
    </div>
</div>

@endsection
