@extends('layouts.admin')

@section('title', 'Kullanıcı Detayı')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-primary"><i class="bi bi-person"></i> Kullanıcı Detayı</h1>
        <div>
            <a href="{{ route('admin.superadmin.users.edit', $user->id) }}" class="btn btn-primary">
                <i class="bi bi-pencil"></i> Düzenle
            </a>
            <a href="{{ route('admin.superadmin.users') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Geri Dön
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <h5 class="card-title mb-4 text-primary">Kullanıcı Bilgileri</h5>
                    
                    <table class="table table-borderless">
                        <tr>
                            <th width="200">Ad Soyad:</th>
                            <td>{{ $user->name }}</td>
                        </tr>
                        <tr>
                            <th>E-posta:</th>
                            <td>{{ $user->email }}</td>
                        </tr>
                        <tr>
                            <th>Telefon:</th>
                            <td>{{ $user->phone ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Rol:</th>
                            <td>
                                <span class="badge bg-{{ $user->role === 'super_admin' ? 'danger' : ($user->role === 'admin' ? 'primary' : 'secondary') }}">
                                    @if($user->role === 'super_admin')
                                        Süper Admin
                                    @else
                                        Randevucu
                                    @endif
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Durum:</th>
                            <td>
                                @if($user->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-secondary">Pasif</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Kayıt Tarihi:</th>
                            <td>{{ $user->created_at->format('d.m.Y H:i') }}</td>
                        </tr>
                        <tr>
                            <th>Son Güncelleme:</th>
                            <td>{{ $user->updated_at->format('d.m.Y H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <h5 class="card-title mb-4 text-primary">Firmalar</h5>
                    
                    @if($user->companies->count() > 0)
                        <ul class="list-group list-group-flush">
                            @foreach($user->companies as $company)
                                <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    <a href="{{ route('admin.superadmin.companies.show', $company->id) }}" class="text-decoration-none">
                                        {{ $company->name }}
                                    </a>
                                    <span class="badge bg-secondary">{{ $company->pivot->role_in_company }}</span>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <p class="text-muted mb-0">Henüz firma atanmamış</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

