<?php

use App\Http\Controllers\Api\SmsController;
use App\Http\Controllers\Api\SmsWebhookController;
use App\Http\Controllers\SmsCallbackController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| iOS App API - /api/ios/*
|--------------------------------------------------------------------------
| Salon/Admin ve Personel için ortak endpoint'ler.
| Personel-only: /api/ios/personel/* (EnsurePersonel middleware)
*/
Route::prefix('ios')->group(function () {
    require __DIR__ . '/api/ios.php';
});

/*
|--------------------------------------------------------------------------
| Android App API - /api/android/*
|--------------------------------------------------------------------------
| iOS ile birebir endpoint akışı.
| Personel-only: /api/android/personel/* (EnsurePersonel middleware)
*/
Route::prefix('android')->group(function () {
    require __DIR__ . '/api/android.php';
});

// SMS Routes
Route::post('/sms/incoming', [SmsCallbackController::class, 'handle']);

Route::prefix('sms')->group(function () {
    
    Route::post('/send', [SmsController::class, 'send']);

    Route::prefix('otp')->group(function () {
        Route::post('/request', [SmsController::class, 'requestOtp']);
        Route::post('/verify', [SmsController::class, 'verifyOtp']);
    });

    Route::get('/logs', [SmsController::class, 'logs']);

    Route::post('/webhook/{provider}', [SmsWebhookController::class, 'handle'])
        ->where('provider', 'interaktif_sms|vatansms|1sms');
});

// API v1 Routes (Clean Architecture)
Route::prefix('v1')->group(function () {
    require __DIR__ . '/api/v1.php';
});
