<?php

use App\Http\Controllers\Api\AndroidApi\AuthController as AndroidAuthController;
use App\Http\Controllers\Api\AndroidApi\DashboardController as AndroidDashboardController;
use App\Http\Controllers\Api\AndroidApi\AppointmentController as AndroidAppointmentController;
use App\Http\Controllers\Api\AndroidApi\AppointmentRequestController as AndroidAppointmentRequestController;
use App\Http\Controllers\Api\AndroidApi\CashboxController as AndroidCashboxController;
use App\Http\Controllers\Api\AndroidApi\InvoiceController as AndroidInvoiceController;
use App\Http\Controllers\Api\AndroidApi\CustomerController as AndroidCustomerController;
use App\Http\Controllers\Api\AndroidApi\ServiceController as AndroidServiceController;
use App\Http\Controllers\Api\AndroidApi\StaffController as AndroidStaffController;
use App\Http\Controllers\Api\AndroidApi\RoomController as AndroidRoomController;
use App\Http\Controllers\Api\AndroidApi\ReportController as AndroidReportController;
use App\Http\Controllers\Api\AndroidApi\NotificationController as AndroidNotificationController;

// Public
Route::post('/login', [AndroidAuthController::class, 'login'])->name('api.android.login');

// Auth required
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AndroidAuthController::class, 'logout'])->name('api.android.logout');
    Route::get('/me', [AndroidAuthController::class, 'me'])->name('api.android.me');
    Route::put('/me', [AndroidAuthController::class, 'updateProfile'])->name('api.android.me.update');
    Route::post('/me/delete-otp', [AndroidAuthController::class, 'sendDeleteOtp'])->name('api.android.me.delete-otp');
    Route::post('/me/verify-delete-otp', [AndroidAuthController::class, 'verifyDeleteOtp'])->name('api.android.me.verify-delete-otp');
    Route::post('/me/delete', [AndroidAuthController::class, 'deleteAccount'])->name('api.android.me.delete');

    Route::get('/dashboard', [AndroidDashboardController::class, 'index'])->name('api.android.dashboard');

    Route::get('/appointments', [AndroidAppointmentController::class, 'index'])->name('api.android.appointments.index');
    Route::get('/appointment-requests', [AndroidAppointmentRequestController::class, 'index'])->name('api.android.appointment-requests.index');
    Route::post('/appointment-requests/{id}/approve', [AndroidAppointmentRequestController::class, 'approve'])->name('api.android.appointment-requests.approve');
    Route::post('/appointment-requests/{id}/reject', [AndroidAppointmentRequestController::class, 'reject'])->name('api.android.appointment-requests.reject');
    Route::get('/appointments/calendar', [AndroidAppointmentController::class, 'calendar'])->name('api.android.appointments.calendar');
    Route::get('/appointments/check-availability', [AndroidAppointmentController::class, 'checkAvailability'])->name('api.android.appointments.check-availability');
    Route::post('/appointments', [AndroidAppointmentController::class, 'store'])->name('api.android.appointments.store');
    Route::get('/appointments/{id}', [AndroidAppointmentController::class, 'show'])->name('api.android.appointments.show');
    Route::put('/appointments/{id}', [AndroidAppointmentController::class, 'update'])->name('api.android.appointments.update');
    Route::post('/appointments/{id}/approve', [AndroidAppointmentController::class, 'approve'])->name('api.android.appointments.approve');
    Route::post('/appointments/{id}/cancel', [AndroidAppointmentController::class, 'cancel'])->name('api.android.appointments.cancel');
    Route::post('/appointments/{id}/complete', [AndroidAppointmentController::class, 'complete'])->name('api.android.appointments.complete');

    Route::get('/cashbox', [AndroidCashboxController::class, 'index'])->name('api.android.cashbox.index');
    Route::post('/cashbox/income', [AndroidCashboxController::class, 'storeIncome'])->name('api.android.cashbox.income');
    Route::post('/cashbox/expense', [AndroidCashboxController::class, 'storeExpense'])->name('api.android.cashbox.expense');

    Route::get('/invoices', [AndroidInvoiceController::class, 'index'])->name('api.android.invoices.index');
    Route::get('/invoices/{id}', [AndroidInvoiceController::class, 'show'])->name('api.android.invoices.show');
    Route::get('/invoices/{id}/pdf', [AndroidInvoiceController::class, 'downloadPdf'])->name('api.android.invoices.pdf');

    Route::get('/customers', [AndroidCustomerController::class, 'index'])->name('api.android.customers.index');
    Route::get('/customers/search', [AndroidCustomerController::class, 'search'])->name('api.android.customers.search');
    Route::post('/customers', [AndroidCustomerController::class, 'store'])->name('api.android.customers.store');
    Route::get('/customers/{id}', [AndroidCustomerController::class, 'show'])->name('api.android.customers.show');
    Route::put('/customers/{id}', [AndroidCustomerController::class, 'update'])->name('api.android.customers.update');

    Route::get('/services', [AndroidServiceController::class, 'index'])->name('api.android.services.index');
    Route::get('/service-categories', [AndroidServiceController::class, 'categories'])->name('api.android.service-categories.index');
    Route::post('/services', [AndroidServiceController::class, 'store'])->name('api.android.services.store');
    Route::get('/services/{id}', [AndroidServiceController::class, 'show'])->name('api.android.services.show');
    Route::put('/services/{id}', [AndroidServiceController::class, 'update'])->name('api.android.services.update');
    Route::delete('/services/{id}', [AndroidServiceController::class, 'destroy'])->name('api.android.services.destroy');

    Route::get('/staff', [AndroidStaffController::class, 'index'])->name('api.android.staff.index');
    Route::post('/staff', [AndroidStaffController::class, 'store'])->name('api.android.staff.store');
    Route::get('/staff/{id}', [AndroidStaffController::class, 'show'])->name('api.android.staff.show');
    Route::put('/staff/{id}', [AndroidStaffController::class, 'update'])->name('api.android.staff.update');
    Route::delete('/staff/{id}', [AndroidStaffController::class, 'destroy'])->name('api.android.staff.destroy');
    Route::get('/staff/{id}/leave-preview', [AndroidStaffController::class, 'leavePreview'])->name('api.android.staff.leave-preview');
    Route::post('/staff/{id}/leave', [AndroidStaffController::class, 'setLeave'])->name('api.android.staff.leave.store');
    Route::delete('/staff/{id}/leave', [AndroidStaffController::class, 'deleteLeave'])->name('api.android.staff.leave.delete');

    Route::get('/rooms', [AndroidRoomController::class, 'index'])->name('api.android.rooms.index');
    Route::post('/rooms', [AndroidRoomController::class, 'store'])->name('api.android.rooms.store');
    Route::get('/rooms/{id}', [AndroidRoomController::class, 'show'])->name('api.android.rooms.show');
    Route::put('/rooms/{id}', [AndroidRoomController::class, 'update'])->name('api.android.rooms.update');
    Route::delete('/rooms/{id}', [AndroidRoomController::class, 'destroy'])->name('api.android.rooms.destroy');

    Route::get('/reports/monthly-appointments', [AndroidReportController::class, 'monthlyAppointments'])->name('api.android.reports.monthly-appointments');
    Route::get('/reports/monthly-revenue', [AndroidReportController::class, 'monthlyRevenue'])->name('api.android.reports.monthly-revenue');
    Route::get('/reports/weekly', [AndroidReportController::class, 'weekly'])->name('api.android.reports.weekly');

    Route::get('/notifications', [AndroidNotificationController::class, 'index'])->name('api.android.notifications.index');
    Route::get('/notifications/unread-count', [AndroidNotificationController::class, 'unreadCount'])->name('api.android.notifications.unread-count');
    Route::post('/notifications/{id}/read', [AndroidNotificationController::class, 'markAsRead'])->name('api.android.notifications.read');
    Route::post('/notifications/read-all', [AndroidNotificationController::class, 'markAllAsRead'])->name('api.android.notifications.read-all');

    Route::prefix('personel')->middleware('personel')->name('api.android.personel.')->group(function () {
        Route::get('/me', [AndroidAuthController::class, 'me'])->name('me');
        Route::put('/me', [AndroidAuthController::class, 'updateProfile'])->name('me.update');
        Route::get('/dashboard', [AndroidDashboardController::class, 'index'])->name('dashboard');
        Route::get('/appointments', [AndroidAppointmentController::class, 'index'])->name('appointments.index');
        Route::get('/appointments/calendar', [AndroidAppointmentController::class, 'calendar'])->name('appointments.calendar');
        Route::get('/appointments/{id}', [AndroidAppointmentController::class, 'show'])->name('appointments.show');
        Route::post('/appointments/{id}/approve', [AndroidAppointmentController::class, 'approve'])->name('appointments.approve');
        Route::post('/appointments/{id}/cancel', [AndroidAppointmentController::class, 'cancel'])->name('appointments.cancel');
        Route::post('/appointments/{id}/complete', [AndroidAppointmentController::class, 'complete'])->name('appointments.complete');
        Route::get('/services', [AndroidServiceController::class, 'index'])->name('services.index');
        Route::get('/services/{id}', [AndroidServiceController::class, 'show'])->name('services.show');
        Route::get('/rooms', [AndroidRoomController::class, 'index'])->name('rooms.index');
        Route::get('/rooms/{id}', [AndroidRoomController::class, 'show'])->name('rooms.show');
        Route::get('/notifications', [AndroidNotificationController::class, 'index'])->name('notifications.index');
        Route::get('/notifications/unread-count', [AndroidNotificationController::class, 'unreadCount'])->name('notifications.unread-count');
        Route::post('/notifications/{id}/read', [AndroidNotificationController::class, 'markAsRead'])->name('notifications.read');
    });
});
