<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\MobileAuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ReservationController;
use App\Http\Controllers\Admin\ReservationCalendarController;
use App\Http\Controllers\Admin\ReservationMessageController;
use App\Http\Controllers\Admin\ReservationOfferController;
use App\Http\Controllers\Admin\WidgetController;
use App\Http\Controllers\Admin\CampaignController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\ContractController;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\ExtraController;
use App\Http\Controllers\Admin\SalonController;
use App\Http\Controllers\Admin\ProcessController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\AccountingController;
use App\Http\Controllers\Admin\CashboxController;
use App\Http\Controllers\Admin\CustomerAccountController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\CompanyController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\AppointmentController;
use App\Http\Controllers\Admin\AccountController;
use App\Http\Controllers\Admin\HelpController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\DownloadController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\SuperAdmin\SuperAdminController;
use App\Http\Controllers\Admin\SearchController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Admin\PersonelController;
use App\Http\Controllers\Admin\PersonelLeaveController;
use App\Http\Controllers\Admin\RoomController;
use App\Http\Controllers\Admin\BeautySalonProfileController;
use App\Http\Controllers\Public\SalonPageController;

Route::get('/', [HomeController::class, 'index'])->middleware('throttle:60,1')->name('home');

Route::get('/indir/windows', [DownloadController::class, 'windows'])->name('download.windows');

Route::get('/sitemap.xml', [\App\Http\Controllers\SitemapController::class, 'index'])->name('sitemap');

Route::get('/salonlar', [\App\Http\Controllers\Public\SalonListController::class, 'index'])->name('public.salons.index');
Route::get('/salon/{slug}', [SalonPageController::class, 'show'])->name('public.salon.show');
Route::get('/salon/{slug}/{phone}', [\App\Http\Controllers\Public\LoyaltyCardController::class, 'show'])->name('public.loyalty-card.show');
Route::get('/salon/{slug}/{token}', [\App\Http\Controllers\Public\SalonRatingController::class, 'show'])->name('public.salon.rating');
Route::post('/salon/{slug}/{token}', [\App\Http\Controllers\Public\SalonRatingController::class, 'store'])->name('public.salon.rating.store');

Route::get('/payment-assets/{name}', function (string $name) {
    $allowed = ['troy.png', 'master.png', 'visa.png'];
    if (!in_array($name, $allowed, true)) {
        abort(404);
    }

    $path = base_path($name);
    if (!file_exists($path)) {
        abort(404);
    }

    return response()->file($path);
})->name('public.payment-asset');

Route::prefix('randevu-talep')->name('public.appointment-request.')->group(function () {
    Route::post('/otp-gonder', [\App\Http\Controllers\Public\AppointmentRequestController::class, 'sendOTP'])->name('send-otp');
    Route::get('/müsait-saatler', [\App\Http\Controllers\Public\AppointmentRequestController::class, 'getAvailableSlots'])->name('available-slots');
    Route::get('/musait-saatler', [\App\Http\Controllers\Public\AppointmentRequestController::class, 'getAvailableSlots'])->name('available-slots-ascii');
    Route::post('/otp-dogrula', [\App\Http\Controllers\Public\AppointmentRequestController::class, 'verifyOTP'])->name('verify-otp');
    Route::post('/', [\App\Http\Controllers\Public\AppointmentRequestController::class, 'store'])->name('store');
});

Route::prefix('api')->group(function () {
    Route::get('/districts', [\App\Http\Controllers\Api\DistrictController::class, 'index'])->name('api.districts');
    Route::get('/salons/search', [\App\Http\Controllers\Public\SalonSearchController::class, 'search'])->name('api.salons.search');
});

Route::get('/hakkimizda', [PageController::class, 'about'])->name('pages.about');
Route::get('/iletisim', [PageController::class, 'contact'])->name('pages.contact');
Route::get('/fiyatlandirma', [PageController::class, 'pricing'])->name('pages.pricing');
Route::get('/kayit', [RegisterController::class, 'showRegistrationForm'])->name('pages.register');
Route::post('/kayit/basvuru', [RegisterController::class, 'storeApplication'])->name('pages.application.store');

Route::get('/gizlilik-politikasi', [PageController::class, 'privacy'])->name('pages.privacy');
Route::get('/kullanim-sartlari', [PageController::class, 'terms'])->name('pages.terms');
Route::get('/kvkk', [PageController::class, 'kvkk'])->name('pages.kvkk');
Route::get('/cerez-politikasi', [PageController::class, 'cookies'])->name('pages.cookies');
Route::get('/satin-alma-sozlesmesi', [PageController::class, 'purchaseAgreement'])->name('pages.purchase-agreement');
Route::get('/sss', [PageController::class, 'faq'])->name('pages.faq');

# PayTR callback - auth olmadan (PayTR sunucusu POST atar)
Route::post('/odeme/callback', [\App\Http\Controllers\PaymentController::class, 'callback'])->name('payment.callback');

Route::prefix('odeme')->name('payment.')->middleware('auth')->group(function () {
    Route::get('/checkout/paket/{packageId}', [\App\Http\Controllers\PaymentController::class, 'checkoutPackage'])->name('checkout.package');
    Route::post('/paket/{packageId}', [\App\Http\Controllers\PaymentController::class, 'initiatePackagePayment'])->name('package.initiate');
    Route::post('/paket/{packageId}/islem', [\App\Http\Controllers\PaymentController::class, 'processPackagePayment'])->name('package.process');
    Route::post('/paket/{packageId}/havale-onay', [\App\Http\Controllers\PaymentController::class, 'confirmBankTransfer'])->name('package.bank-transfer.confirm');
    Route::post('/sms', [\App\Http\Controllers\PaymentController::class, 'initiateSmsPayment'])->name('sms.initiate');
    Route::get('/basarili', [\App\Http\Controllers\PaymentController::class, 'success'])->name('success');
    Route::get('/basarisiz', [\App\Http\Controllers\PaymentController::class, 'fail'])->name('fail');
});

Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

Route::get('/logout', function() {
    auth()->logout();
    try {
        if (request()->hasSession()) {
            request()->session()->invalidate();
            request()->session()->regenerateToken();
        }
    } catch (\Throwable $e) {
        // Sessiyon temizlenemezse bile devam et
    }
    $homeUrl = rtrim(config('app.url', ''), '/') ?: '/';
    return response('', 302)->header('Location', $homeUrl);
})->name('logout.get');

Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('/register/check-email', [RegisterController::class, 'checkEmail'])->name('register.check-email');
Route::post('/register/check-phone', [RegisterController::class, 'checkPhone'])->name('register.check-phone');
Route::post('/register/send-otp', [RegisterController::class, 'sendRegistrationOtp'])->name('register.send-otp');

Route::prefix('admin/mobile')
    ->middleware(['mobile.only'])
    ->group(function () {
        
        Route::get('/login', [MobileAuthController::class, 'showLoginForm'])->name('mobile.login');
        Route::post('/login', [MobileAuthController::class, 'login'])->name('mobile.login.post');
        Route::get('/register', [MobileAuthController::class, 'showRegisterForm'])->name('mobile.register');
        Route::post('/register', [MobileAuthController::class, 'register'])->name('mobile.register.post');
        Route::post('/logout', [MobileAuthController::class, 'logout'])->name('mobile.logout');
        Route::get('/logout', [MobileAuthController::class, 'logout'])->name('mobile.logout.get');

        Route::middleware(['auth'])->group(function () {
            Route::get('/dashboard', [\App\Http\Controllers\Admin\Mobile\MobileDashboardController::class, 'index'])->name('mobile.dashboard');

            Route::get('/appointments', [\App\Http\Controllers\Admin\Mobile\MobileReservationController::class, 'index'])->name('mobile.appointments.index');
            Route::get('/appointments/create', [\App\Http\Controllers\Admin\Mobile\MobileReservationController::class, 'create'])->name('mobile.appointments.create');
            Route::post('/appointments', [\App\Http\Controllers\Admin\Mobile\MobileReservationController::class, 'store'])->name('mobile.appointments.store');
            Route::get('/appointments/{id}', [\App\Http\Controllers\Admin\Mobile\MobileReservationController::class, 'show'])->name('mobile.appointments.show');
            Route::post('/appointments/{id}/complete', [\App\Http\Controllers\Admin\Mobile\MobileReservationController::class, 'complete'])->name('mobile.appointments.complete');
            Route::post('/appointments/{id}/cancel', [\App\Http\Controllers\Admin\Mobile\MobileReservationController::class, 'cancel'])->name('mobile.appointments.cancel');

            Route::get('/customers', [\App\Http\Controllers\Admin\Mobile\MobileCustomerController::class, 'index'])->name('mobile.customers.index');
            Route::post('/customers', [\App\Http\Controllers\Admin\Mobile\MobileCustomerController::class, 'store'])->name('mobile.customers.store');
            Route::get('/customers/{id}', [\App\Http\Controllers\Admin\Mobile\MobileCustomerController::class, 'show'])->name('mobile.customers.show');
            Route::get('/customers/{id}/edit', [\App\Http\Controllers\Admin\Mobile\MobileCustomerController::class, 'edit'])->name('mobile.customers.edit');
            Route::put('/customers/{id}', [\App\Http\Controllers\Admin\Mobile\MobileCustomerController::class, 'update'])->name('mobile.customers.update');

            Route::get('/accounting', [\App\Http\Controllers\Admin\Mobile\MobileAccountingController::class, 'index'])->name('mobile.accounting.index');
            Route::post('/accounting/income', [\App\Http\Controllers\Admin\Mobile\MobileAccountingController::class, 'storeIncome'])->name('mobile.accounting.store-income');
            Route::post('/accounting/expense', [\App\Http\Controllers\Admin\Mobile\MobileAccountingController::class, 'storeExpense'])->name('mobile.accounting.store-expense');
            Route::delete('/accounting/{id}', [\App\Http\Controllers\Admin\Mobile\MobileAccountingController::class, 'destroy'])->name('mobile.accounting.destroy');

            Route::get('/settings', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'index'])->name('mobile.settings.index');
            Route::get('/settings/profile', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'profile'])->name('mobile.settings.profile');
            Route::post('/settings/profile', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'updateProfile'])->name('mobile.settings.profile.update');
            Route::post('/settings/password', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'changePassword'])->name('mobile.settings.password');
            Route::post('/settings/phone-otp', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'sendPhoneOtp'])->name('mobile.settings.phone-otp');
            Route::post('/settings/phone', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'changePhone'])->name('mobile.settings.phone');
            Route::post('/settings/delete-otp', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'sendDeleteOtp'])->name('mobile.settings.delete-otp');
            Route::delete('/settings/account', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'destroy'])->name('mobile.settings.destroy');

            Route::get('/settings/invoices', [\App\Http\Controllers\Admin\Mobile\MobileInvoiceController::class, 'index'])->name('mobile.settings.invoices.index');
            Route::post('/settings/invoices/{id}/sms', [\App\Http\Controllers\Admin\Mobile\MobileInvoiceController::class, 'sendSms'])->name('mobile.settings.invoices.sms');
            Route::delete('/settings/invoices/{id}', [\App\Http\Controllers\Admin\Mobile\MobileInvoiceController::class, 'destroy'])->name('mobile.settings.invoices.destroy');

            Route::get('/settings/membership', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'membership'])->name('mobile.settings.membership');

            Route::get('/settings/salons', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'salonsIndex'])->name('mobile.settings.salons.index');
            Route::get('/settings/salons/{id}', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'salonsShow'])->name('mobile.settings.salons.show');
            Route::get('/settings/salons/{id}/edit', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'salonsEdit'])->name('mobile.settings.salons.edit');
            Route::put('/settings/salons/{id}', [\App\Http\Controllers\Admin\Mobile\MobileSettingsController::class, 'salonsUpdate'])->name('mobile.settings.salons.update');

            Route::get('/calendar', [\App\Http\Controllers\Admin\Mobile\MobileCalendarController::class, 'index'])->name('mobile.calendar.index');
            Route::get('/calendar/feed', [\App\Http\Controllers\Admin\Mobile\MobileCalendarController::class, 'feed'])->name('mobile.calendar.feed');
        });
    });
Route::post('/register', [RegisterController::class, 'register']);
Route::post('/register/update-info', [RegisterController::class, 'updateRegistrationInfo'])->middleware('auth')->name('register.update-info');

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ReservationApiController;
use App\Http\Controllers\Api\CustomerApiController;
use App\Http\Controllers\Api\SalonApiController;
use App\Http\Controllers\Api\DashboardApiController;
use App\Http\Controllers\Api\InvoiceApiController;
use App\Http\Controllers\Api\ContractApiController;
use App\Http\Controllers\Api\CashboxApiController;
use App\Http\Controllers\Api\MenuApiController;
use App\Http\Controllers\Api\ExtraApiController;
use App\Http\Controllers\Api\ProcessApiController;
use App\Http\Controllers\Api\ServiceApiController;
use App\Http\Controllers\Api\AppointmentApiController;
use App\Http\Controllers\Api\ContactApiController;
use App\Http\Controllers\Api\CompanyApiController;
use App\Http\Controllers\Api\ReportApiController;
use App\Http\Controllers\Api\CampaignApiController;
use App\Http\Controllers\Api\HealthController;

// iOS API route'ları routes/api/ios.php'de tanımlı (api.php üzerinden /api/ios/*)

Route::prefix('api/mobile')->name('api.mobile.')->group(function () {
    
    Route::get('/health', [HealthController::class, 'check'])->name('health');

    Route::post('/login', [AuthController::class, 'login'])->name('login');
    Route::post('/send-otp', [AuthController::class, 'sendOTP'])->name('send-otp');
    Route::post('/verify-otp', [AuthController::class, 'verifyOTP'])->name('verify-otp');

    Route::middleware('auth:sanctum')->group(function () {
        Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
        Route::get('/me', [AuthController::class, 'me'])->name('me');
        Route::post('/refresh-token', [AuthController::class, 'refreshToken'])->name('refresh-token');

        Route::get('/permissions', [\App\Http\Controllers\Api\Mobile\PermissionController::class, 'index'])->name('permissions');

        Route::post('/register-device', [\App\Http\Controllers\Api\Mobile\DeviceRegistrationController::class, 'register'])->name('register-device');
        Route::delete('/register-device/{token}', [\App\Http\Controllers\Api\Mobile\DeviceRegistrationController::class, 'unregister'])->name('unregister-device');

        Route::get('/notifications', [\App\Http\Controllers\Api\Mobile\NotificationController::class, 'index'])->name('notifications.index');
        Route::get('/notifications/unread-count', [\App\Http\Controllers\Api\Mobile\NotificationController::class, 'unreadCount'])->name('notifications.unread-count');
        Route::post('/notifications/{id}/read', [\App\Http\Controllers\Api\Mobile\NotificationController::class, 'markAsRead'])->name('notifications.read');
        
        Route::get('/dashboard', [DashboardApiController::class, 'index'])->name('dashboard.index');

        Route::get('/appointments', [ReservationApiController::class, 'index'])->name('appointments.index');
        Route::get('/appointments/upcoming', [ReservationApiController::class, 'upcoming'])->name('appointments.upcoming');
        Route::post('/appointments', [ReservationApiController::class, 'store'])->name('appointments.store');
        Route::get('/appointments/{id}', [ReservationApiController::class, 'show'])->name('appointments.show');
        Route::put('/appointments/{id}', [ReservationApiController::class, 'update'])->name('appointments.update');
        Route::delete('/appointments/{id}', [ReservationApiController::class, 'destroy'])->name('appointments.destroy');
        Route::get('/appointments/check-times', [ReservationApiController::class, 'checkAvailableTimes'])->name('appointments.check-times');
        Route::post('/appointments/{id}/approve', [ReservationApiController::class, 'approve'])->name('appointments.approve');
        Route::post('/appointments/{id}/cancel', [ReservationApiController::class, 'cancel'])->name('appointments.cancel');
        Route::post('/appointments/{id}/complete', [ReservationApiController::class, 'complete'])->name('appointments.complete');

        Route::get('/customers', [CustomerApiController::class, 'index'])->name('customers.index');
        Route::get('/customers/search', [CustomerApiController::class, 'search'])->name('customers.search');
        Route::post('/customers', [CustomerApiController::class, 'store'])->name('customers.store');
        Route::get('/customers/{id}', [CustomerApiController::class, 'show'])->name('customers.show');
        Route::put('/customers/{id}', [CustomerApiController::class, 'update'])->name('customers.update');
        Route::delete('/customers/{id}', [CustomerApiController::class, 'destroy'])->name('customers.destroy');

        Route::get('/salons', [SalonApiController::class, 'index'])->name('salons.index');

        Route::get('/invoices', [\App\Http\Controllers\Api\InvoiceApiController::class, 'index'])->name('invoices.index');
        Route::post('/invoices', [\App\Http\Controllers\Api\InvoiceApiController::class, 'store'])->name('invoices.store');
        Route::get('/invoices/{id}', [\App\Http\Controllers\Api\InvoiceApiController::class, 'show'])->name('invoices.show');
        Route::get('/invoices/{id}/pdf', [\App\Http\Controllers\Api\InvoiceApiController::class, 'downloadPdf'])->name('invoices.pdf');
        Route::post('/invoices/{id}/send-sms', [\App\Http\Controllers\Admin\InvoiceController::class, 'sendSms'])->name('invoices.send-sms');

        Route::get('/contracts', [ContractApiController::class, 'index'])->name('contracts.index');
        Route::get('/contracts/{id}', [ContractApiController::class, 'show'])->name('contracts.show');

        Route::get('/cashbox', [CashboxApiController::class, 'index'])->name('cashbox.index');
        Route::post('/cashbox/income', [CashboxApiController::class, 'storeIncome'])->name('cashbox.income.store');
        Route::post('/cashbox/expense', [CashboxApiController::class, 'storeExpense'])->name('cashbox.expense.store');

        Route::get('/menus', [MenuApiController::class, 'index'])->name('menus.index');
        Route::post('/menus', [MenuApiController::class, 'store'])->name('menus.store');
        Route::get('/menus/{id}', [MenuApiController::class, 'show'])->name('menus.show');
        Route::put('/menus/{id}', [MenuApiController::class, 'update'])->name('menus.update');
        Route::delete('/menus/{id}', [MenuApiController::class, 'destroy'])->name('menus.destroy');

        Route::get('/extras', [ExtraApiController::class, 'index'])->name('extras.index');
        Route::post('/extras', [ExtraApiController::class, 'store'])->name('extras.store');
        Route::get('/extras/{id}', [ExtraApiController::class, 'show'])->name('extras.show');
        Route::put('/extras/{id}', [ExtraApiController::class, 'update'])->name('extras.update');
        Route::delete('/extras/{id}', [ExtraApiController::class, 'destroy'])->name('extras.destroy');

        Route::get('/processes', [ProcessApiController::class, 'index'])->name('processes.index');
        Route::post('/processes', [ProcessApiController::class, 'store'])->name('processes.store');
        Route::get('/processes/{id}', [ProcessApiController::class, 'show'])->name('processes.show');
        Route::put('/processes/{id}', [ProcessApiController::class, 'update'])->name('processes.update');
        Route::delete('/processes/{id}', [ProcessApiController::class, 'destroy'])->name('processes.destroy');

        Route::get('/services', [\App\Http\Controllers\Api\ServiceApiController::class, 'index'])->name('services.index');
        Route::post('/services', [\App\Http\Controllers\Api\ServiceApiController::class, 'store'])->name('services.store');
        Route::get('/services/{id}', [\App\Http\Controllers\Api\ServiceApiController::class, 'show'])->name('services.show');
        Route::put('/services/{id}', [\App\Http\Controllers\Api\ServiceApiController::class, 'update'])->name('services.update');
        Route::delete('/services/{id}', [\App\Http\Controllers\Api\ServiceApiController::class, 'destroy'])->name('services.destroy');

        Route::get('/staff', [\App\Http\Controllers\Api\StaffApiController::class, 'index'])->name('staff.index');
        Route::get('/staff/{id}', [\App\Http\Controllers\Api\StaffApiController::class, 'show'])->name('staff.show');
        Route::get('/staff/{id}/schedule', [\App\Http\Controllers\Api\StaffApiController::class, 'schedule'])->name('staff.schedule');

        Route::get('/rooms', [\App\Http\Controllers\Api\RoomApiController::class, 'index'])->name('rooms.index');
        Route::post('/rooms', [\App\Http\Controllers\Api\RoomApiController::class, 'store'])->name('rooms.store');
        Route::get('/rooms/{id}', [\App\Http\Controllers\Api\RoomApiController::class, 'show'])->name('rooms.show');
        Route::put('/rooms/{id}', [\App\Http\Controllers\Api\RoomApiController::class, 'update'])->name('rooms.update');
        Route::delete('/rooms/{id}', [\App\Http\Controllers\Api\RoomApiController::class, 'destroy'])->name('rooms.destroy');

        Route::get('/appointments', [AppointmentApiController::class, 'index'])->name('appointments.index');
        Route::post('/appointments', [AppointmentApiController::class, 'store'])->name('appointments.store');
        Route::get('/appointments/{id}', [AppointmentApiController::class, 'show'])->name('appointments.show');
        Route::put('/appointments/{id}', [AppointmentApiController::class, 'update'])->name('appointments.update');
        Route::delete('/appointments/{id}', [AppointmentApiController::class, 'destroy'])->name('appointments.destroy');

        Route::get('/contacts', [ContactApiController::class, 'index'])->name('contacts.index');
        Route::post('/contacts', [ContactApiController::class, 'store'])->name('contacts.store');
        Route::get('/contacts/{id}', [ContactApiController::class, 'show'])->name('contacts.show');
        Route::put('/contacts/{id}', [ContactApiController::class, 'update'])->name('contacts.update');
        Route::delete('/contacts/{id}', [ContactApiController::class, 'destroy'])->name('contacts.destroy');

        Route::get('/companies', [CompanyApiController::class, 'index'])->name('companies.index');
        Route::post('/companies', [CompanyApiController::class, 'store'])->name('companies.store');
        Route::get('/companies/{id}', [CompanyApiController::class, 'show'])->name('companies.show');
        Route::put('/companies/{id}', [CompanyApiController::class, 'update'])->name('companies.update');
        Route::delete('/companies/{id}', [CompanyApiController::class, 'destroy'])->name('companies.destroy');

        Route::get('/reports/monthly-appointments', [ReportApiController::class, 'monthlyReservations'])->name('reports.monthly-appointments');
        Route::get('/reports/monthly-revenue', [ReportApiController::class, 'monthlyRevenue'])->name('reports.monthly-revenue');
        Route::get('/reports/weekly', [ReportApiController::class, 'weekly'])->name('reports.weekly');

        Route::get('/campaigns/sms-balance', [CampaignApiController::class, 'getSmsBalance'])->name('campaigns.sms-balance');
        Route::post('/campaigns/send-bulk-sms', [CampaignApiController::class, 'sendBulkSms'])->name('campaigns.send-bulk-sms');
        Route::post('/campaigns/generate-referral-code', [CampaignApiController::class, 'generateReferralCode'])->name('campaigns.generate-referral-code');
        Route::get('/campaigns/referral-stats', [CampaignApiController::class, 'getReferralStats'])->name('campaigns.referral-stats');
    });
});

Route::middleware(['auth', 'check.license', 'package.expiration', 'require.salon'])->prefix('admin')->name('admin.')->group(function () {

    Route::get('/paket-secimi', [\App\Http\Controllers\Admin\PackageSelectionController::class, 'index'])->name('packages.select');
    Route::post('/paket-secimi/kupon-uygula', [\App\Http\Controllers\Admin\CouponController::class, 'apply'])->name('packages.coupon.apply');
    Route::post('/paket-secimi/{packageId}/satin-al', [\App\Http\Controllers\Admin\PackageSelectionController::class, 'purchase'])->name('packages.purchase');

    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    Route::prefix('randevu')->name('reservations.')->group(function () {
        Route::get('/takvim', [ReservationCalendarController::class, 'index'])->name('calendar');
        Route::get('/takvim-feed', [ReservationCalendarController::class, 'feed'])->name('calendar.feed');
        Route::get('/tum-yil-takvimi', [ReservationCalendarController::class, 'year'])->name('year-calendar');
        Route::get('/tum-yil-takvimi-v2', [ReservationCalendarController::class, 'yearV2'])->name('year-calendar-v2');
        Route::get('/mesajlar', [ReservationMessageController::class, 'index'])->name('messages');
        Route::get('/gunluk', [ReservationController::class, 'daily'])->name('daily');
        Route::get('/iptal', [ReservationController::class, 'cancelled'])->name('cancelled');
        Route::get('/acik', [ReservationController::class, 'open'])->name('open');
        Route::get('/teklifler', [ReservationOfferController::class, 'index'])->name('offers');
        Route::get('/site-takvim', [WidgetController::class, 'calendarEmbed'])->name('widget-calendar');
        Route::post('/check-times', [ReservationController::class, 'checkAvailableTimes'])->name('check-times');
    });

    Route::get('/randevular/check-availability', [ReservationController::class, 'checkAvailability'])->name('reservations.check-availability');
    Route::post('/randevular/{id}/onayla', [ReservationController::class, 'confirm'])->name('reservations.confirm');
    Route::post('/randevular/{id}/tamamla', [ReservationController::class, 'complete'])->name('reservations.complete');
    Route::post('/randevular/{id}/sms', [ReservationController::class, 'sendSms'])->name('reservations.send-sms');
    Route::get('/fatura/{id}', [InvoiceController::class, 'show'])->name('invoices.show');
    Route::post('/fatura/kaydet', [InvoiceController::class, 'store'])->name('invoices.store');
    Route::post('/fatura/{id}/sms', [InvoiceController::class, 'sendSms'])->name('invoices.send-sms');
    Route::get('/sozlesme/randevu/{reservationId}', [ContractController::class, 'showForReservation'])->name('contracts.show-reservation');

    Route::prefix('kampanyalar')->name('campaigns.')->group(function () {
        Route::get('/sms-kazan', [CampaignController::class, 'sms'])->name('sms');
        Route::get('/tavsiye', [CampaignController::class, 'referral'])->name('referral');
    });

    Route::prefix('ayarlar')->name('settings.')->group(function () {
        Route::get('/uyelik', [SettingsController::class, 'membership'])->name('membership');
        Route::post('/uyelik', [SettingsController::class, 'updateMembership']);
        Route::get('/fatura-bilgileri', [SettingsController::class, 'invoiceInfo'])->name('invoice-info');
        Route::post('/fatura-bilgileri', [SettingsController::class, 'updateInvoiceInfo'])->name('invoice-info.update');
        Route::get('/kisisel-faturalar', [SettingsController::class, 'personalInvoices'])->name('personal-invoices');
        Route::get('/muhasebe-grup', [SettingsController::class, 'accounting'])->name('accounting');
        Route::post('/muhasebe-grup', [SettingsController::class, 'updateAccounting']);
        Route::get('/randevu-form', [SettingsController::class, 'reservationForm'])->name('reservation-form');
        Route::post('/randevu-form', [SettingsController::class, 'updateReservationForm']);
        Route::get('/takvim', [SettingsController::class, 'calendar'])->name('calendar');
        Route::post('/takvim', [SettingsController::class, 'updateCalendar']);
        Route::get('/sozlesme-grup', [ContractController::class, 'index'])->name('contracts.index');
        Route::get('/sozlesme-grup/olustur', [ContractController::class, 'create'])->name('contracts.create');
        Route::post('/sozlesme-grup', [ContractController::class, 'store'])->name('contracts.store');
        Route::get('/sozlesme-grup/{id}/duzenle', [ContractController::class, 'edit'])->name('contracts.edit');
        Route::put('/sozlesme-grup/{id}', [ContractController::class, 'update'])->name('contracts.update');
        Route::delete('/sozlesme-grup/{id}', [ContractController::class, 'destroy'])->name('contracts.destroy');
        Route::post('/sozlesme-grup/{id}/varsayilan', [ContractController::class, 'setDefault'])->name('contracts.set-default');
        Route::get('/sozlesme/varsayilan-url', [ContractController::class, 'getDefaultContractUrl'])->name('contracts.default-url');
        Route::get('/sozlesme/randevu/{reservationId}', [ContractController::class, 'showForReservation'])->name('contracts.show-reservation');
        Route::get('/menuler', [MenuController::class, 'index'])->name('menus.index');
        Route::get('/menuler/olustur', [MenuController::class, 'create'])->name('menus.create');
        Route::post('/menuler', [MenuController::class, 'store'])->name('menus.store');
        Route::get('/menuler/{id}/duzenle', [MenuController::class, 'edit'])->name('menus.edit');
        Route::put('/menuler/{id}', [MenuController::class, 'update'])->name('menus.update');
        Route::delete('/menuler/{id}', [MenuController::class, 'destroy'])->name('menus.destroy');
        Route::get('/extralar', [ExtraController::class, 'index'])->name('extras.index');
        Route::get('/extralar/olustur', [ExtraController::class, 'create'])->name('extras.create');
        Route::post('/extralar', [ExtraController::class, 'store'])->name('extras.store');
        Route::get('/extralar/{id}/duzenle', [ExtraController::class, 'edit'])->name('extras.edit');
        Route::put('/extralar/{id}', [ExtraController::class, 'update'])->name('extras.update');
        Route::delete('/extralar/{id}', [ExtraController::class, 'destroy'])->name('extras.destroy');
        Route::get('/salon-yonetimi', [SalonController::class, 'index'])->name('salons.index');
        Route::get('/salon-yonetimi/olustur', [SalonController::class, 'create'])->name('salons.create');
        Route::post('/salon-yonetimi', [SalonController::class, 'store'])->name('salons.store');
        Route::get('/salon-yonetimi/{id}/duzenle', [SalonController::class, 'edit'])->name('salons.edit');
        Route::put('/salon-yonetimi/{id}', [SalonController::class, 'update'])->name('salons.update');
        Route::delete('/salon-yonetimi/{id}', [SalonController::class, 'destroy'])->name('salons.destroy');
        Route::get('/email-bildirim', [SettingsController::class, 'email'])->name('email');
        Route::post('/email-bildirim', [SettingsController::class, 'updateEmail']);
        Route::get('/sms', [SettingsController::class, 'sms'])->name('sms');
        Route::post('/sms', [SettingsController::class, 'updateSms'])->name('sms.update');
        Route::post('/sms/test', [SettingsController::class, 'testSms'])->name('sms.test');
        Route::get('/ana-sayfa', [SettingsController::class, 'homepage'])->name('homepage');
        Route::post('/ana-sayfa', [SettingsController::class, 'updateHomepage'])->name('homepage.update');
        Route::get('/genel-ayarlar', [SettingsController::class, 'general'])->name('general');
        Route::post('/genel-ayarlar', [SettingsController::class, 'updateGeneral'])->name('general.update');
        Route::get('/faturalar', [InvoiceController::class, 'index'])->name('invoices.index');
        Route::get('/faturalar/{id}/pdf', [InvoiceController::class, 'showPdf'])->name('invoices.pdf');
        Route::post('/faturalar/{id}/sms', [InvoiceController::class, 'sendSms'])->name('invoices.send-sms');
        Route::get('/islemler', [ProcessController::class, 'index'])->name('processes.index');
        Route::get('/islemler/olustur', [ProcessController::class, 'create'])->name('processes.create');
        Route::post('/islemler', [ProcessController::class, 'store'])->name('processes.store');
        Route::get('/islemler/{id}/duzenle', [ProcessController::class, 'edit'])->name('processes.edit');
        Route::put('/islemler/{id}', [ProcessController::class, 'update'])->name('processes.update');
        Route::delete('/islemler/{id}', [ProcessController::class, 'destroy'])->name('processes.destroy');
        
        Route::get('/servisler', [ServiceController::class, 'index'])->name('services.index');
        Route::get('/servisler/olustur', [ServiceController::class, 'create'])->name('services.create');
        Route::post('/servisler', [ServiceController::class, 'store'])->name('services.store');
        Route::get('/servisler/{id}/duzenle', [ServiceController::class, 'edit'])->name('services.edit');
        Route::put('/servisler/{id}', [ServiceController::class, 'update'])->name('services.update');
        Route::delete('/servisler/{id}', [ServiceController::class, 'destroy'])->name('services.destroy');
    });
    
    // Odalar route'u settings prefix'i dışında, doğrudan admin altında
    Route::resource('odalar', RoomController::class)->names([
        'index' => 'rooms.index',
        'create' => 'rooms.create',
        'store' => 'rooms.store',
        'show' => 'rooms.show',
        'edit' => 'rooms.edit',
        'update' => 'rooms.update',
        'destroy' => 'rooms.destroy',
    ]);

    Route::get('/salonlar', [SalonController::class, 'index'])->name('salons.index');
    Route::post('/salonlar', [SalonController::class, 'store'])->name('salons.store');

    Route::prefix('guzellik-salonu')->name('beauty-salon.')->middleware('check.beauty-salon')->group(function () {
        
        Route::get('/profil', [BeautySalonProfileController::class, 'edit'])->name('profile');
        Route::put('/profil', [BeautySalonProfileController::class, 'update'])->name('profile.update');
        Route::post('/profil/send-phone-otp', [BeautySalonProfileController::class, 'sendPhoneChangeOtp'])->name('profile.send-phone-otp');
        
        // Services ve Rooms route'ları
        Route::get('/hizmetler', [ServiceController::class, 'index'])->name('services.index');
        Route::get('/hizmetler/olustur', [ServiceController::class, 'create'])->name('services.create');
        Route::post('/hizmetler', [ServiceController::class, 'store'])->name('services.store');
        Route::get('/hizmetler/{id}/duzenle', [ServiceController::class, 'edit'])->name('services.edit');
        Route::put('/hizmetler/{id}', [ServiceController::class, 'update'])->name('services.update');
        Route::delete('/hizmetler/{id}', [ServiceController::class, 'destroy'])->name('services.destroy');
        
        Route::resource('odalar', RoomController::class)->names([
            'index' => 'rooms.index',
            'create' => 'rooms.create',
            'store' => 'rooms.store',
            'show' => 'rooms.show',
            'edit' => 'rooms.edit',
            'update' => 'rooms.update',
            'destroy' => 'rooms.destroy',
        ]);

        // Premium SaaS Modules Routes
        Route::prefix('sadakat')->name('loyalty.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\LoyaltyController::class, 'index'])->name('index');
            Route::get('/seviyeler', [\App\Http\Controllers\Admin\LoyaltyController::class, 'tiers'])->name('tiers');
            Route::post('/seviyeler', [\App\Http\Controllers\Admin\LoyaltyController::class, 'storeTier'])->name('tiers.store');
            Route::get('/oduller', [\App\Http\Controllers\Admin\LoyaltyController::class, 'rewards'])->name('rewards');
            Route::post('/oduller', [\App\Http\Controllers\Admin\LoyaltyController::class, 'storeReward'])->name('rewards.store');
            Route::get('/musteriler', [\App\Http\Controllers\Admin\LoyaltyController::class, 'customers'])->name('customers');
        });

        Route::prefix('kampanyalar')->name('campaigns.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\CampaignController::class, 'index'])->name('index');
            Route::get('/yeni', [\App\Http\Controllers\Admin\CampaignController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\CampaignController::class, 'store'])->name('store');
            Route::get('/{id}', [\App\Http\Controllers\Admin\CampaignController::class, 'show'])->name('show');
            Route::get('/{id}/duzenle', [\App\Http\Controllers\Admin\CampaignController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\CampaignController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\CampaignController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('referans')->name('referrals.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\ReferralController::class, 'index'])->name('index');
            Route::get('/oduller', [\App\Http\Controllers\Admin\ReferralController::class, 'rewards'])->name('rewards');
            Route::get('/gecmis', [\App\Http\Controllers\Admin\ReferralController::class, 'history'])->name('history');
        });

        Route::prefix('uyelik')->name('memberships.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\MembershipController::class, 'index'])->name('index');
            Route::get('/paketler', [\App\Http\Controllers\Admin\MembershipController::class, 'packages'])->name('packages');
            Route::post('/paketler', [\App\Http\Controllers\Admin\MembershipController::class, 'storePackage'])->name('packages.store');
            Route::get('/paketler/{id}', [\App\Http\Controllers\Admin\MembershipController::class, 'showPackage'])->name('packages.show');
            Route::put('/paketler/{id}', [\App\Http\Controllers\Admin\MembershipController::class, 'updatePackage'])->name('packages.update');
            Route::delete('/paketler/{id}', [\App\Http\Controllers\Admin\MembershipController::class, 'destroyPackage'])->name('packages.destroy');
            Route::get('/musteriler', [\App\Http\Controllers\Admin\MembershipController::class, 'customers'])->name('customers');
        });

        Route::prefix('subeler')->name('branches.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\BranchController::class, 'index'])->name('index');
            Route::get('/yeni', [\App\Http\Controllers\Admin\BranchController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\BranchController::class, 'store'])->name('store');
            Route::get('/{id}', [\App\Http\Controllers\Admin\BranchController::class, 'show'])->name('show');
            Route::get('/{id}/duzenle', [\App\Http\Controllers\Admin\BranchController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\BranchController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\BranchController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('personel-performans')->name('staff-performance.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\StaffPerformanceController::class, 'index'])->name('index');
            Route::get('/komisyonlar', [\App\Http\Controllers\Admin\StaffPerformanceController::class, 'commissions'])->name('commissions');
            Route::post('/komisyonlar', [\App\Http\Controllers\Admin\StaffPerformanceController::class, 'storeCommission'])->name('commissions.store');
            Route::get('/bonuslar', [\App\Http\Controllers\Admin\StaffPerformanceController::class, 'bonuses'])->name('bonuses');
            Route::post('/bonuslar', [\App\Http\Controllers\Admin\StaffPerformanceController::class, 'storeBonus'])->name('bonuses.store');
        });

        Route::prefix('personel-maas')->name('staff-salary.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\StaffSalaryController::class, 'index'])->name('index');
            Route::post('/hesapla', [\App\Http\Controllers\Admin\StaffSalaryController::class, 'calculate'])->name('calculate');
            Route::post('/{id}/odendi', [\App\Http\Controllers\Admin\StaffSalaryController::class, 'markAsPaid'])->name('mark-paid');
        });

        Route::prefix('musteri-degeri')->name('clv.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\ClvController::class, 'index'])->name('index');
            Route::post('/hesapla', [\App\Http\Controllers\Admin\ClvController::class, 'calculateClv'])->name('calculate');
            Route::get('/segmentler', [\App\Http\Controllers\Admin\ClvController::class, 'segments'])->name('segments');
            Route::get('/segmentler/olustur', [\App\Http\Controllers\Admin\ClvController::class, 'createSegment'])->name('segments.create');
            Route::post('/segmentler', [\App\Http\Controllers\Admin\ClvController::class, 'storeSegment'])->name('segments.store');
            Route::get('/segmentler/{id}/duzenle', [\App\Http\Controllers\Admin\ClvController::class, 'editSegment'])->name('segments.edit');
            Route::put('/segmentler/{id}', [\App\Http\Controllers\Admin\ClvController::class, 'updateSegment'])->name('segments.update');
            Route::delete('/segmentler/{id}', [\App\Http\Controllers\Admin\ClvController::class, 'destroySegment'])->name('segments.destroy');
            Route::get('/teklifler', [\App\Http\Controllers\Admin\ClvController::class, 'offers'])->name('offers');
        });

        Route::prefix('akilli-indirim')->name('smart-discount.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\SmartDiscountController::class, 'index'])->name('index');
            Route::post('/', [\App\Http\Controllers\Admin\SmartDiscountController::class, 'store'])->name('store');
            Route::put('/{id}', [\App\Http\Controllers\Admin\SmartDiscountController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\SmartDiscountController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('musteri-rehberi')->name('customer-directory.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\CustomerDirectoryController::class, 'index'])->name('index');
            Route::post('/mesaj-gonder', [\App\Http\Controllers\Admin\CustomerDirectoryController::class, 'sendMessage'])->name('send-message');
            Route::get('/sablon', [\App\Http\Controllers\Admin\CustomerDirectoryController::class, 'getTemplate'])->name('get-template');
        });

        Route::resource('personel', PersonelController::class)->names([
            'index' => 'personel.index',
            'create' => 'personel.create',
            'store' => 'personel.store',
            'show' => 'personel.show',
            'edit' => 'personel.edit',
            'update' => 'personel.update',
            'destroy' => 'personel.destroy',
        ]);

        Route::get('/personel/{personelId}/services', [\App\Http\Controllers\Admin\PersonelServiceController::class, 'index'])->name('personel.services.index');
        Route::post('/personel/{personelId}/services', [\App\Http\Controllers\Admin\PersonelServiceController::class, 'store'])->name('personel.services.store');
        Route::put('/personel/{personelId}/services/{id}', [\App\Http\Controllers\Admin\PersonelServiceController::class, 'update'])->name('personel.services.update');
        Route::delete('/personel/{personelId}/services/{id}', [\App\Http\Controllers\Admin\PersonelServiceController::class, 'destroy'])->name('personel.services.destroy');

        Route::get('hizmet-kategorileri', [\App\Http\Controllers\Admin\ServiceCategoryController::class, 'index'])->name('service-categories.index');
        Route::get('hizmet-kategorileri/yeni', [\App\Http\Controllers\Admin\ServiceCategoryController::class, 'create'])->name('service-categories.create');
        Route::post('hizmet-kategorileri', [\App\Http\Controllers\Admin\ServiceCategoryController::class, 'store'])->name('service-categories.store');
        Route::get('hizmet-kategorileri/{id}/duzenle', [\App\Http\Controllers\Admin\ServiceCategoryController::class, 'edit'])->name('service-categories.edit');
        Route::put('hizmet-kategorileri/{id}', [\App\Http\Controllers\Admin\ServiceCategoryController::class, 'update'])->name('service-categories.update');
        Route::delete('hizmet-kategorileri/{id}', [\App\Http\Controllers\Admin\ServiceCategoryController::class, 'destroy'])->name('service-categories.destroy');

        Route::get('hizmetler', [\App\Http\Controllers\Admin\ServiceController::class, 'index'])->name('services.index');
        Route::get('hizmetler/kategori/{categoryId}', [\App\Http\Controllers\Admin\ServiceController::class, 'indexByCategory'])->name('services.index-by-category');
        Route::get('hizmetler/kategori/{categoryId}/yeni', [\App\Http\Controllers\Admin\ServiceController::class, 'create'])->name('services.create');
        Route::post('hizmetler', [\App\Http\Controllers\Admin\ServiceController::class, 'store'])->name('services.store');
        Route::get('hizmetler/{id}/duzenle', [\App\Http\Controllers\Admin\ServiceController::class, 'edit'])->name('services.edit');
        Route::put('hizmetler/{id}', [\App\Http\Controllers\Admin\ServiceController::class, 'update'])->name('services.update');
        Route::delete('hizmetler/{id}', [\App\Http\Controllers\Admin\ServiceController::class, 'destroy'])->name('services.destroy');

        Route::get('/fiyat-listesi', [\App\Http\Controllers\Admin\BeautySalonPriceListController::class, 'index'])->name('price-list.index');

        Route::post('/personel/{personelId}/hizmetler', [\App\Http\Controllers\Admin\PersonelController::class, 'assignServices'])->name('personel.assign-services');
        Route::delete('/personel/{personelId}/hizmetler/{serviceId}', [\App\Http\Controllers\Admin\PersonelController::class, 'removeService'])->name('personel.remove-service');
        Route::get('/personel/{personelId}/busy-hours', [\App\Http\Controllers\Admin\PersonelController::class, 'getBusyHours'])->name('personel.busy-hours');
        Route::get('/personel/{personelId}/izin/preview', [PersonelLeaveController::class, 'preview'])->name('personel.leave.preview');
        Route::post('/personel/{personelId}/izin', [PersonelLeaveController::class, 'store'])->name('personel.leave.store');
        Route::delete('/personel/{personelId}/izin', [PersonelLeaveController::class, 'destroy'])->name('personel.leave.destroy');

        Route::prefix('randevu-talepleri')->name('appointment-requests.')->group(function () {
            Route::get('/musteri-portfoyu/{customerId}', [\App\Http\Controllers\Admin\AppointmentRequestManagementController::class, 'customerPortfolio'])->name('customer-portfolio');
            Route::get('/data', [\App\Http\Controllers\Admin\AppointmentRequestManagementController::class, 'getData'])->name('data');
            Route::get('/musteri/{customerId}', [\App\Http\Controllers\Admin\AppointmentRequestManagementController::class, 'getCustomerInfo'])->name('customer-info');
            Route::get('/', [\App\Http\Controllers\Admin\AppointmentRequestManagementController::class, 'index'])->name('index');
            Route::get('/{id}', [\App\Http\Controllers\Admin\AppointmentRequestManagementController::class, 'show'])->name('show');
            Route::post('/{id}/onayla', [\App\Http\Controllers\Admin\AppointmentRequestManagementController::class, 'approve'])->name('approve');
            Route::post('/{id}/reddet', [\App\Http\Controllers\Admin\AppointmentRequestManagementController::class, 'reject'])->name('reject');
        });
    });

    Route::prefix('muhasebe')->name('accounting.')->middleware(\App\Http\Middleware\PreventPersonelAccess::class)->group(function () {
        Route::get('/gelirler', [AccountingController::class, 'income'])->name('income');
        Route::post('/gelirler', [AccountingController::class, 'storeIncome'])->name('income.store');
        Route::get('/giderler', [AccountingController::class, 'expense'])->name('expense');
        Route::post('/giderler', [AccountingController::class, 'storeExpense'])->name('expense.store');
        Route::get('/cariler', [CustomerAccountController::class, 'index'])->name('customers');
        Route::get('/cariler/{id}', [CustomerAccountController::class, 'show'])->name('customers.show');
        Route::get('/randevu-gelirleri', [AccountingController::class, 'reservationIncome'])->name('reservation-income');
        Route::get('/gelecek-kaporalar', [AccountingController::class, 'deposits'])->name('deposits');
        Route::get('/kalan-bakiyeler', [AccountingController::class, 'balances'])->name('balances');
        Route::get('/kasa', [CashboxController::class, 'index'])->name('cashbox');
        Route::post('/kasa/gelir', [CashboxController::class, 'storeIncome'])->name('cashbox.income.store');
        Route::post('/kasa/gider', [CashboxController::class, 'storeExpense'])->name('cashbox.expense.store');
        Route::get('/kasa/rapor', [CashboxController::class, 'report'])->name('cashbox.report');
        Route::post('/kasa/yeniden-hesapla', [CashboxController::class, 'recalculate'])->name('cashbox.recalculate');
        Route::get('/kasa/{id}/fatura', [CashboxController::class, 'getInvoiceForTransaction'])->name('cashbox.invoice');
        Route::get('/kasa/{id}', [CashboxController::class, 'show'])->name('cashbox.show');
        Route::put('/kasa/{id}', [CashboxController::class, 'update'])->name('cashbox.update');
        Route::delete('/kasa/{id}', [CashboxController::class, 'destroy'])->name('cashbox.destroy');
    });

    Route::prefix('raporlar')->name('reports.')->group(function () {
        Route::get('/aylik-randevu', [ReportController::class, 'monthlyReservations'])->name('monthly-reservations');
        Route::get('/aylik-gelir', [ReportController::class, 'monthlyRevenue'])->name('monthly-revenue');
        Route::get('/haftalik', [ReportController::class, 'weekly'])->name('weekly');
    });

    Route::resource('musteriler', CustomerController::class)->names(['index' => 'customers.index', 'create' => 'customers.create', 'store' => 'customers.store', 'show' => 'customers.show', 'edit' => 'customers.edit', 'update' => 'customers.update', 'destroy' => 'customers.destroy']);
    Route::post('/musteriler/{id}/sil', [CustomerController::class, 'destroy'])->name('customers.destroy.post');
    Route::get('/musteriler/{id}/bakiye', [CustomerController::class, 'balance'])->name('customers.balance');
    Route::put('/musteriler/{id}/toggle-loyalty-card', [CustomerController::class, 'toggleLoyaltyCard'])->name('customers.toggle-loyalty-card');
    Route::get('/api/musteriler/search', [CustomerController::class, 'search'])->name('customers.search');

    Route::get('/musteriler/ara', [CustomerController::class, 'search'])->name('customers.ajax-search');

    Route::resource('rehber', ContactController::class)->names(['index' => 'contacts.index', 'create' => 'contacts.create', 'store' => 'contacts.store', 'edit' => 'contacts.edit', 'update' => 'contacts.update', 'destroy' => 'contacts.destroy']);

    Route::resource('firmalar', CompanyController::class)->names(['index' => 'companies.index', 'create' => 'companies.create', 'store' => 'companies.store', 'edit' => 'companies.edit', 'update' => 'companies.update', 'destroy' => 'companies.destroy']);

    Route::get('/randevular', [ReservationController::class, 'index'])->name('appointments.index');
    Route::get('/randevular/create', [ReservationController::class, 'create'])->name('appointments.create');
    Route::post('/randevular/recurring/create', [ReservationController::class, 'createRecurring'])->name('appointments.recurring.create');
    Route::get('/randevular/{id}', [ReservationController::class, 'show'])->name('appointments.show');
    Route::post('/randevular', [ReservationController::class, 'store'])->name('appointments.store');
    Route::get('/randevular/{id}/edit', [ReservationController::class, 'edit'])->name('appointments.edit');
    Route::put('/randevular/{id}', [ReservationController::class, 'update'])->name('appointments.update');
    Route::delete('/randevular/{id}', [ReservationController::class, 'destroy'])->name('appointments.destroy');
    Route::post('/randevular/{id}/status', [ReservationController::class, 'updateStatus'])->name('appointments.update-status');
    Route::post('/randevular/{id}/confirm', [ReservationController::class, 'confirm'])->name('appointments.confirm');
    Route::post('/randevular/{id}/complete', [ReservationController::class, 'complete'])->name('appointments.complete');
    Route::post('/randevular/check-times', [ReservationController::class, 'checkAvailableTimes'])->name('appointments.check-times');

    Route::get('/hesap', [AccountController::class, 'index'])->name('account.index');
    Route::put('/hesap', [AccountController::class, 'update'])->name('account.update');
    Route::post('/hesap/send-delete-otp', [AccountController::class, 'sendDeleteOtp'])->name('account.send-delete-otp');
    Route::post('/hesap/send-password-change-otp', [AccountController::class, 'sendPasswordChangeOtp'])->name('account.send-password-change-otp');
    Route::post('/hesap/change-password', [AccountController::class, 'changePassword'])->name('account.change-password');
    Route::post('/hesap/send-phone-change-otp', [AccountController::class, 'sendPhoneChangeOtp'])->name('account.send-phone-change-otp');
    Route::post('/hesap/change-phone', [AccountController::class, 'changePhone'])->name('account.change-phone');
    Route::delete('/hesap', [AccountController::class, 'destroy'])->name('account.destroy');
    Route::post('/hesap/destroy', [AccountController::class, 'destroy'])->name('admin.account.destroy');

    Route::get('/yardim/sss', [HelpController::class, 'faq'])->name('help.faq');
    Route::get('/yardim/destek', [HelpController::class, 'support'])->name('help.support');
    Route::post('/yardim/destek', [HelpController::class, 'submitSupport'])->name('help.submit');

    Route::get('/search', [SearchController::class, 'search'])->name('search');

    Route::get('/bildirimler', [\App\Http\Controllers\Admin\NotificationController::class, 'index'])->name('notifications.index');
    Route::get('/api/bugunku-randevular', [\App\Http\Controllers\Admin\NotificationController::class, 'todayAppointments'])->name('notifications.today');
    Route::get('/api/yaklasan-randevular', [\App\Http\Controllers\Admin\NotificationController::class, 'upcomingAppointments'])->name('notifications.upcoming');
    Route::get('/api/bildirimler', [\App\Http\Controllers\Admin\NotificationController::class, 'getNotifications'])->name('notifications.get');

    Route::get('/sms-paketleri', [\App\Http\Controllers\Admin\SmsPackageController::class, 'index'])->name('sms-packages.index');

    Route::prefix('faturalar')->name('invoices.')->group(function () {
        Route::get('/{id}/download-pdf', [InvoiceController::class, 'downloadPdf'])->name('download-pdf');
        Route::post('/{id}/send-sms', [InvoiceController::class, 'sendSms'])->name('send-sms');
        Route::delete('/{id}', [InvoiceController::class, 'destroy'])->name('destroy');
    });

    Route::get('/superadmin', [SuperAdminController::class, 'dashboard'])->name('superadmin.dashboard');

    Route::get('/kullanicilar', [SuperAdminController::class, 'users'])->name('superadmin.users');
    Route::get('/kullanicilar/olustur', [SuperAdminController::class, 'createUser'])->name('superadmin.users.create');
    Route::post('/kullanicilar', [SuperAdminController::class, 'storeUser'])->name('superadmin.users.store');
    Route::get('/kullanicilar/{id}', [SuperAdminController::class, 'showUser'])->name('superadmin.users.show');
    Route::get('/kullanicilar/{id}/duzenle', [SuperAdminController::class, 'editUser'])->name('superadmin.users.edit');
    Route::put('/kullanicilar/{id}', [SuperAdminController::class, 'updateUser'])->name('superadmin.users.update');
    Route::delete('/kullanicilar/{id}', [SuperAdminController::class, 'destroyUser'])->name('superadmin.users.destroy');
    Route::post('/kullanicilar/{id}/sil', [SuperAdminController::class, 'destroyUser'])->name('superadmin.users.destroy.post');

    Route::get('/kullanicilar-yonetim', [\App\Http\Controllers\SuperAdmin\UserManagementController::class, 'index'])->name('superadmin.user-management');
    Route::post('/kullanicilar/{id}/sms-bakiye', [\App\Http\Controllers\SuperAdmin\UserManagementController::class, 'updateSmsBalance'])->name('superadmin.update-sms-balance');
    Route::post('/kullanicilar/{id}/lisans', [\App\Http\Controllers\SuperAdmin\UserManagementController::class, 'updateLicense'])->name('superadmin.update-license');
    Route::get('/salon-yildizlari', [SuperAdminController::class, 'salonRatings'])->name('superadmin.salon-ratings.index');
    Route::put('/salon-yildizlari/{id}', [SuperAdminController::class, 'updateSalonRating'])->name('superadmin.salon-ratings.update');

    Route::get('/firmalar-yonetim', [SuperAdminController::class, 'companies'])->name('superadmin.companies');
    Route::get('/firmalar-yonetim/olustur', [SuperAdminController::class, 'createCompany'])->name('superadmin.companies.create');
    Route::post('/firmalar-yonetim', [SuperAdminController::class, 'storeCompany'])->name('superadmin.companies.store');
    Route::get('/firmalar-yonetim/{id}', [SuperAdminController::class, 'showCompany'])->name('superadmin.companies.show');
    Route::get('/firmalar-yonetim/{id}/duzenle', [SuperAdminController::class, 'editCompany'])->name('superadmin.companies.edit');
    Route::put('/firmalar-yonetim/{id}', [SuperAdminController::class, 'updateCompany'])->name('superadmin.companies.update');
    Route::delete('/firmalar-yonetim/{id}', [SuperAdminController::class, 'destroyCompany'])->name('superadmin.companies.destroy');
    Route::post('/firmalar-yonetim/{id}/sil', [SuperAdminController::class, 'destroyCompany'])->name('superadmin.companies.destroy.post');

    Route::prefix('paketler')->name('superadmin.packages.')->group(function () {
        Route::get('/', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'index'])->name('index');
        Route::get('/create', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'create'])->name('create');
        Route::post('/', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'edit'])->name('edit');
        Route::put('/{id}', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'update'])->name('update');
        Route::delete('/{id}', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('kuponlar')->name('superadmin.coupons.')->group(function () {
        Route::get('/', [\App\Http\Controllers\SuperAdmin\CouponController::class, 'index'])->name('index');
        Route::get('/create', [\App\Http\Controllers\SuperAdmin\CouponController::class, 'create'])->name('create');
        Route::post('/', [\App\Http\Controllers\SuperAdmin\CouponController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [\App\Http\Controllers\SuperAdmin\CouponController::class, 'edit'])->name('edit');
        Route::put('/{id}', [\App\Http\Controllers\SuperAdmin\CouponController::class, 'update'])->name('update');
        Route::delete('/{id}', [\App\Http\Controllers\SuperAdmin\CouponController::class, 'destroy'])->name('destroy');
    });

    Route::get('/bekleyen-odemeler', [\App\Http\Controllers\SuperAdmin\PendingPaymentsController::class, 'index'])->name('superadmin.pending-payments');
    Route::post('/bekleyen-odemeler/{id}/onayla', [\App\Http\Controllers\SuperAdmin\PendingPaymentsController::class, 'approve'])->name('superadmin.pending-payments.approve');
    Route::post('/bekleyen-odemeler/{id}/reddet', [\App\Http\Controllers\SuperAdmin\PendingPaymentsController::class, 'reject'])->name('superadmin.pending-payments.reject');

    Route::get('/paket-fiyatlari', [SuperAdminController::class, 'pricingSettings'])->name('superadmin.pricing-settings');
    Route::post('/paket-fiyatlari', [SuperAdminController::class, 'updatePricingSettings'])->name('superadmin.pricing-settings.update');

    Route::get('/uygulama-indirmeleri', [SuperAdminController::class, 'appDownloads'])->name('superadmin.app-downloads');
    Route::post('/uygulama-indirmeleri', [SuperAdminController::class, 'updateAppDownloads'])->name('superadmin.app-downloads.update');

    Route::get('/test-sms', [SuperAdminController::class, 'testSms'])->name('superadmin.test-sms');
    Route::post('/test-sms/send', [SuperAdminController::class, 'sendTestSms'])->name('superadmin.test-sms.send');
    Route::post('/test-sms/otp', [SuperAdminController::class, 'sendTestOtp'])->name('superadmin.test-sms.otp');


    Route::prefix('musteri-yorumlari')->name('superadmin.testimonials.')->group(function () {
        Route::get('/', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'index'])->name('index');
        Route::get('/create', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'create'])->name('create');
        Route::post('/', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'edit'])->name('edit');
        Route::put('/{id}', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'update'])->name('update');
        Route::delete('/{id}', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('global-sozlesme')->name('superadmin.global-contract.')->group(function () {
        Route::get('/', [\App\Http\Controllers\SuperAdmin\GlobalContractController::class, 'index'])->name('index');
        Route::post('/', [\App\Http\Controllers\SuperAdmin\GlobalContractController::class, 'store'])->name('store');
        Route::delete('/', [\App\Http\Controllers\SuperAdmin\GlobalContractController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('faturalar')->name('invoices.')->group(function () {
        Route::get('/{id}/download-pdf', [InvoiceController::class, 'downloadPdf'])->name('download-pdf');
        Route::post('/{id}/send-sms', [InvoiceController::class, 'sendSms'])->name('send-sms');
        Route::delete('/{id}', [InvoiceController::class, 'destroy'])->name('destroy');
    });
});

Route::get('/fatura/{token}', [\App\Http\Controllers\PublicInvoiceController::class, 'show'])->name('public.invoice');
Route::get('/fatura/{token}/pdf', [\App\Http\Controllers\PublicInvoiceController::class, 'downloadPdf'])->name('public.invoice.pdf');

Route::get('/sozlesme/{token}', [\App\Http\Controllers\PublicContractController::class, 'show'])->name('public.contract');

Route::middleware(['auth'])->prefix('personel')->name('personel.')->group(function () {
    
    Route::get('/profil', [\App\Http\Controllers\Personel\ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profil', [\App\Http\Controllers\Personel\ProfileController::class, 'update'])->name('profile.update');
    Route::get('/dashboard', [\App\Http\Controllers\Personel\PersonelDashboardController::class, 'index'])->name('dashboard');
    Route::get('/randevular', [\App\Http\Controllers\Personel\PersonelDashboardController::class, 'appointments'])->name('appointments');
    Route::get('/calendar', [\App\Http\Controllers\Personel\PersonelDashboardController::class, 'calendar'])->name('calendar');
    Route::get('/calendar/feed', [\App\Http\Controllers\Personel\PersonelDashboardController::class, 'calendarFeed'])->name('calendar.feed');
});

Route::get('/{shortUrl}', [\App\Http\Controllers\Public\ShortUrlController::class, 'redirect'])->name('public.short-url.redirect');
